package org.simantics.scl.osgi.internal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.TestScriptExecutor;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class BundleTestScriptRunnable implements TestRunnable {

    private final String name;
    private final URL url;
    
    public BundleTestScriptRunnable(String name, URL url) {
        this.name = name;
        this.url = url;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run() throws Exception {
        InputStream stream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        
        SCLContext context = SCLContext.getCurrent();
        SCLReportingHandler printer = (SCLReportingHandler)context.get(SCLReportingHandler.REPORTING_HANDLER);
        SCLReportingHandler handler;
        if(printer instanceof SCLReportingHandler)
            handler = (SCLReportingHandler)printer;
        else
            handler = SCLReportingHandler.DEFAULT;
        
        try {
            CommandSession session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, handler);
            new TestScriptExecutor(session, reader, handler).execute();
        } finally {
            reader.close();
        }
    }

    @Override
    public String toString() {
        return getName() + " (" + url + ")";
    }
}
