/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.nativemem.internal.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.simantics.nativemem.internal.Resource;

public class Stat {
    private static final String SELF_STATM = "/proc/self/statm";
    private static final Charset ASCII = Charset.forName("US-ASCII");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getCurrentRSS(Resource r) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                BufferedReader rdr = Files.newBufferedReader(Paths.get(SELF_STATM, new String[0]), ASCII);
                try {
                    String line = rdr.readLine();
                    String[] nums = line.split(" ");
                    if (nums.length == 0) {
                        return 0L;
                    }
                    long rss = Long.parseLong(nums[0]);
                    long pageSize = r.sysconf(30);
                    return rss * pageSize;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (rdr == null) return 0L;
                    rdr.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }
}

