/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.handlers.e4;

import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.modeling.ui.documents.OpenPlainTextDocumentAdapter;
import org.simantics.modeling.ui.property.TypicalPropertyTester;
import org.simantics.modeling.ui.typicals.RuleChooserDialog;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class SyncCurrentTypicalTemplateToInstances {
    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart mActiveEditor) throws DatabaseException, InterruptedException {
        IEditorPart activeEditor = null;
        if (mActiveEditor != null && mActiveEditor.getObject() instanceof CompatibilityEditor) {
            CompatibilityEditor compEditor = (CompatibilityEditor)mActiveEditor.getObject();
            activeEditor = compEditor.getEditor();
        } else {
            activeEditor = WorkbenchUtils.getActiveEditor();
        }
        if (activeEditor == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        IResourceEditorInput input = (IResourceEditorInput)activeEditor.getEditorInput();
        return TypicalPropertyTester.isTypicalMasterEditor((RequestProcessor)Simantics.getSession(), input.getResource());
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="e4ActivePart") MPart mActiveEditor) {
        IEditorPart activeEditor = null;
        Object editor = mActiveEditor.getObject();
        if (editor instanceof CompatibilityEditor) {
            CompatibilityEditor compEditor = (CompatibilityEditor)editor;
            activeEditor = compEditor.getEditor();
        } else {
            activeEditor = WorkbenchUtils.getActiveEditor();
        }
        if (activeEditor == null) {
            return;
        }
        IResourceEditorInput input = (IResourceEditorInput)activeEditor.getEditorInput();
        Session session = Simantics.getSession();
        try {
            if (!TypicalPropertyTester.isTypicalMasterEditor((RequestProcessor)session, input.getResource())) {
                MessageDialog.openInformation((Shell)shell, (String)"Not Synchronizing", (String)"Currently active editor is not a typical diagram template editor.");
                return;
            }
            RuleChooserDialog.RuleResult result = RuleChooserDialog.choose(shell, "Synchronizing typical template to all its instances.", new Resource[]{input.getResource()});
            if (result == null) {
                return;
            }
            session.markUndoPoint();
            SyncTypicalTemplatesToInstances req = new SyncTypicalTemplatesToInstances(result.selectedRules, new Resource[]{input.getResource()}).logging(result.logging);
            session.syncRequest((Write)req);
            if (result.logging) {
                for (Resource log : req.logs) {
                    new OpenPlainTextDocumentAdapter().openEditor(log);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }
}

