/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.e4;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.osgi.framework.Bundle;
import org.simantics.db.Resource;
import org.simantics.modeling.ui.diagramEditor.DisposingPolicy;
import org.simantics.modeling.ui.diagramEditor.e4.DiagramViewer;
import org.simantics.modeling.ui.diagramEditor.e4.Messages;
import org.simantics.ui.workbench.e4.E4ResourceEditorBase;
import org.simantics.utils.ui.ErrorLogger;

public class DiagramEditor
extends E4ResourceEditorBase
implements DiagramViewer.DiagramViewerHost,
IExecutableExtension,
IPartListener {
    public static final String ARG_VIEWER = "viewer";
    private Composite parent;
    private String viewerContributor;
    private String viewerClassName;
    private DiagramViewer viewer;
    private static final DisposingPolicy DISPOSING_POLICY = new DisposingPolicy();
    private Runnable disposer = new Runnable(){

        @Override
        public void run() {
            DiagramEditor.this.tryDisposeViewer();
        }
    };

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        if (data instanceof String) {
            String[] parameters;
            this.viewerContributor = cfig.getContributor().getName();
            String[] stringArray = parameters = ((String)data).split(";");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] keyValue = parameter.split("=");
                if (keyValue.length > 2) {
                    ErrorLogger.defaultLogWarning((String)NLS.bind((String)Messages.DiagramEditor_InvalidParameter, (Object)parameter, (Object)data), null);
                } else {
                    String value;
                    String key = keyValue[0];
                    String string = value = keyValue.length > 1 ? keyValue[1] : "";
                    if (ARG_VIEWER.equals(key)) {
                        this.viewerClassName = value;
                    }
                }
                ++n2;
            }
        }
    }

    protected DiagramViewer createViewer() throws PartInitException {
        if (this.viewerClassName == null) {
            throw new PartInitException("DiagramViewer contributor class was not specified in editor extension's class attribute viewer-argument. contributor is '" + this.viewerContributor + "'");
        }
        try {
            Bundle b = Platform.getBundle((String)this.viewerContributor);
            if (b == null) {
                throw new PartInitException("DiagramViewer '" + this.viewerClassName + "' contributor bundle '" + this.viewerContributor + "' was not found in the platform.");
            }
            Class clazz = b.loadClass(this.viewerClassName);
            if (!DiagramViewer.class.isAssignableFrom(clazz)) {
                throw new PartInitException("DiagramViewer class '" + this.viewerClassName + "' is not assignable to " + DiagramViewer.class + ".");
            }
            Constructor ctor = clazz.getConstructor(new Class[0]);
            return (DiagramViewer)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PartInitException("Failed to instantiate DiagramViewer implementation '" + this.viewerClassName + "' from bundle '" + this.viewerContributor + "'. See exception for details.", (Throwable)e);
        }
    }

    public DiagramViewer getViewer() {
        return this.viewer;
    }

    public Resource getRuntimeResource() {
        DiagramViewer viewer = this.viewer;
        return viewer != null ? viewer.getRuntime() : null;
    }

    public void initImpl(MPart part) {
        super.initImpl(part);
        try {
            this.viewer = this.createViewer();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        EPartService partService = (EPartService)part.getContext().get(EPartService.class);
        partService.addPartListener((IPartListener)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.initializeViewer();
    }

    private void initializeViewer() {
        this.parent.setBackground(this.parent.getDisplay().getSystemColor(1));
        this.viewer.createPartControl(this.parent);
        if (this.parent.isDisposed()) {
            return;
        }
        this.parent.layout(true);
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        Object result;
        if (adapter == DiagramViewer.class) {
            return this.viewer;
        }
        if (this.viewer != null && (result = this.viewer.getAdapter(adapter)) != null) {
            return result;
        }
        return null;
    }

    public void dispose() {
        EPartService partService = (EPartService)this.getPart().getContext().get(EPartService.class);
        partService.removePartListener((IPartListener)this);
        DISPOSING_POLICY.removeDisposer(this.disposer);
        this.tryDisposeViewer();
    }

    @Override
    public void doSetPartName(String name) {
        this.getPart().setLabel(name);
    }

    @Override
    public void doSetTitleToolTip(String tooltip) {
        this.getPart().setTooltip(tooltip);
    }

    private void tryDisposeViewer() {
        if (this.viewer != null) {
            Composite viewerComposite = this.viewer.getComposite();
            this.viewer.dispose();
            this.viewer = null;
            if (viewerComposite != null) {
                viewerComposite.dispose();
            }
        }
    }

    public void partVisible(MPart part) {
        if (this.getPart().equals(part)) {
            DISPOSING_POLICY.removeDisposer(this.disposer);
            if (this.viewer == null) {
                try {
                    this.viewer = this.createViewer();
                    this.initializeViewer();
                }
                catch (PartInitException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        }
    }

    public void partHidden(MPart part) {
        if (this.getPart().equals(part)) {
            DISPOSING_POLICY.addDisposer(this.disposer);
        }
    }

    public void partDeactivated(MPart part) {
    }

    public void partBroughtToTop(MPart part) {
    }

    public void partActivated(MPart part) {
    }
}

