/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypePropertiesResult;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerData;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerPropertyInfo;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerSection;
import org.simantics.modeling.ui.componentTypeEditor.Messages;
import org.simantics.modeling.ui.componentTypeEditor.StringWriter;
import org.simantics.modeling.userComponent.ComponentTypeCommands;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.structural.stubs.StructuralResource2;

public class DerivedPropertiesSection
implements ComponentTypeViewerSection {
    private static final String[] COLUMN_NAMES = new String[]{Messages.DerivedPropertiesSection_Name, Messages.DerivedPropertiesSection_Type, Messages.DerivedPropertiesSection_Expression, Messages.DerivedPropertiesSection_Unit, Messages.DerivedPropertiesSection_Label, Messages.DerivedPropertiesSection_Description};
    private static final int[] COLUMN_LENGTHS = new int[]{120, 100, 100, 70, 100, 100};
    private static final int[] COLUMN_WEIGHTS;
    private static Function4<RequestProcessor, Resource, Resource, String, String> VALIDATE_MONITOR_EXPRESSION;
    ComponentTypeViewerData data;
    Table table;
    TableColumn[] columns;
    TableEditor editor;
    Button newProperty;
    Button removeProperty;
    Section section;
    private static final Object MONITOR;

    static {
        int[] nArray = new int[6];
        nArray[2] = 100;
        COLUMN_WEIGHTS = nArray;
        VALIDATE_MONITOR_EXPRESSION = new Function4<RequestProcessor, Resource, Resource, String, String>(){

            public String apply(RequestProcessor p0, Resource p1, Resource p2, String p3) {
                return DerivedPropertiesSection.validateMonitorExpression(p0, p1, p2, p3);
            }
        };
        MONITOR = new Object();
    }

    public DerivedPropertiesSection(final ComponentTypeViewerData data) {
        this.data = data;
        FormToolkit tk = data.tk;
        Form form = data.form;
        this.section = tk.createSection(form.getBody(), 320);
        this.section.setLayout((Layout)new FillLayout());
        this.section.setText(Messages.DerivedPropertiesSection_DerivedProperties);
        Composite sectionBody = tk.createComposite((Composite)this.section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionBody);
        this.section.setClient((Control)sectionBody);
        Composite tableComposite = tk.createComposite(sectionBody);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tcl = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcl);
        this.table = tk.createTable(tableComposite, 67586);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.columns = new TableColumn[COLUMN_NAMES.length];
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            TableColumn column;
            this.columns[i] = column = new TableColumn(this.table, 0);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(COLUMN_WEIGHTS[i], COLUMN_LENGTHS[i], true));
            column.setText(COLUMN_NAMES[i]);
            ++i;
        }
        this.editor = new TableEditor(this.table);
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        this.editor.horizontalAlignment = 16384;
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditor = DerivedPropertiesSection.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if (data.readOnly) {
                    return;
                }
                Rectangle tableBounds = DerivedPropertiesSection.this.table.getClientArea();
                int rx = e.x - tableBounds.x;
                int ry = e.y - tableBounds.y;
                TableItem selectedItem = null;
                int selectedColumn = -1;
                Rectangle selectedItemBounds = null;
                TableItem[] tableItemArray = DerivedPropertiesSection.this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    int column = 0;
                    while (column < COLUMN_NAMES.length) {
                        Rectangle bounds = item.getBounds(column);
                        if (bounds.contains(rx, ry)) {
                            selectedItemBounds = bounds;
                            selectedItem = item;
                            selectedColumn = column;
                            break;
                        }
                        ++column;
                    }
                    ++n2;
                }
                if (selectedItem == null) {
                    return;
                }
                int column = selectedColumn;
                ComponentTypeViewerPropertyInfo propertyInfo = (ComponentTypeViewerPropertyInfo)selectedItem.getData();
                final Resource resource = propertyInfo.resource;
                switch (column) {
                    case 0: {
                        data.editName(DerivedPropertiesSection.this.table, DerivedPropertiesSection.this.editor, propertyInfo, selectedItem, column, ComponentTypeViewerData.PROPERTY_NAME_PATTERN);
                        break;
                    }
                    case 1: {
                        data.editType(DerivedPropertiesSection.this.table, DerivedPropertiesSection.this.editor, propertyInfo, selectedItem, column, false);
                        break;
                    }
                    case 2: {
                        data.editValue(DerivedPropertiesSection.this.table, DerivedPropertiesSection.this.editor, propertyInfo, selectedItem, column, propertyInfo.immutable ? null : new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                ComponentTypeCommands.setMonitorExpression((WriteGraph)graph, (Resource)data.componentType, (Resource)resource, (String)newValue);
                            }
                        }, (Function4<RequestProcessor, Resource, Resource, String, String>)VALIDATE_MONITOR_EXPRESSION);
                        break;
                    }
                    case 3: {
                        data.editUnit(DerivedPropertiesSection.this.table, DerivedPropertiesSection.this.editor, propertyInfo, selectedItem, column);
                        break;
                    }
                    case 4: {
                        data.editValue(DerivedPropertiesSection.this.table, DerivedPropertiesSection.this.editor, propertyInfo, selectedItem, column, propertyInfo.immutable ? null : new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                graph.markUndoPoint();
                                String value = newValue.isEmpty() ? null : newValue;
                                ComponentTypeCommands.setLabel((WriteGraph)graph, (Resource)resource, (String)value);
                            }
                        }, null);
                        break;
                    }
                    case 5: {
                        data.editMultilineText(DerivedPropertiesSection.this.table, DerivedPropertiesSection.this.editor, propertyInfo, selectedItem, selectedItemBounds, column, new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                graph.markUndoPoint();
                                String value = newValue.isEmpty() ? null : newValue;
                                ComponentTypeCommands.setDescription((WriteGraph)graph, (Resource)resource, (String)value);
                            }
                        });
                    }
                }
            }
        });
        Composite buttons = tk.createComposite(sectionBody);
        GridDataFactory.fillDefaults().applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        this.newProperty = tk.createButton(buttons, Messages.DerivedPropertiesSection_NewProperty, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.newProperty);
        this.removeProperty = tk.createButton(buttons, Messages.DerivedPropertiesSection_RemoveProperty, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.removeProperty);
        this.newProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DerivedPropertiesSection.this.editor.getEditor() != null) {
                    DerivedPropertiesSection.this.editor.getEditor().dispose();
                }
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        ComponentTypeCommands.createMonitorPropertyWithDefaults((WriteGraph)graph, (Resource)data.componentType);
                    }
                });
            }
        });
        this.removeProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DerivedPropertiesSection.this.editor.getEditor() != null) {
                    DerivedPropertiesSection.this.editor.getEditor().dispose();
                }
                final ArrayList<Resource> propertiesToBeRemoved = new ArrayList<Resource>();
                TableItem[] tableItemArray = DerivedPropertiesSection.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    propertiesToBeRemoved.add(((ComponentTypeViewerPropertyInfo)item.getData()).resource);
                    ++n2;
                }
                if (!propertiesToBeRemoved.isEmpty()) {
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            for (Resource property : propertiesToBeRemoved) {
                                ComponentTypeCommands.removeProperty((WriteGraph)graph, (Resource)data.componentType, (Resource)property);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        boolean e = !readOnly;
        this.newProperty.setEnabled(e);
        this.removeProperty.setEnabled(e);
    }

    public static String validateMonitorExpression(RequestProcessor processor, final Resource componentType, final Resource relation, String expression) {
        if (expression.trim().isEmpty()) {
            return Messages.DerivedPropertiesSection_ExpressionIsEmpty;
        }
        if (expression.trim().isEmpty()) {
            return Messages.DerivedPropertiesSection_ExpressionIsEmpty;
        }
        try {
            return (String)processor.sync((ReadInterface)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    Resource cfr_ignored_0 = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(componentType));
                    Iterator iterator = graph.getAssertedObjects(componentType, relation).iterator();
                    while (iterator.hasNext()) {
                        Resource cfr_ignored_1 = (Resource)iterator.next();
                        try {
                            graph.isInstanceOf(componentType, STR.ProceduralComponentType);
                        }
                        catch (Exception e) {
                            String msg = e.getMessage();
                            int index = msg.indexOf(":");
                            if (index > 0) {
                                msg = msg.substring(index);
                            }
                            return msg;
                        }
                    }
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void update(ComponentTypePropertiesResult result) {
        if (this.table.isDisposed()) {
            return;
        }
        HashSet<ComponentTypeViewerPropertyInfo> selected = new HashSet<ComponentTypeViewerPropertyInfo>();
        ArrayList<TableItem> selectedItems = new ArrayList<TableItem>(selected.size());
        int[] nArray = this.table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TableItem item = this.table.getItem(i);
            selected.add((ComponentTypeViewerPropertyInfo)item.getData());
            ++n2;
        }
        int topIndex = this.table.getTopIndex();
        this.table.removeAll();
        if (this.editor.getEditor() != null) {
            this.editor.getEditor().dispose();
        }
        for (ComponentTypeViewerPropertyInfo info : result.getProperties()) {
            Color fg;
            boolean immutable = result.isImmutable() || info.immutable;
            Color color = fg = immutable ? this.table.getDisplay().getSystemColor(16) : null;
            if (info.sectionSpecificData != MONITOR) continue;
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, info.valid != null ? String.valueOf(info.name) + " (!)" : info.name);
            item.setText(1, info.type);
            item.setText(2, info.expression);
            item.setText(3, info.unitString());
            item.setText(4, info.label);
            item.setText(5, info.description);
            item.setForeground(fg);
            item.setData((Object)info);
            if (!selected.contains(info)) continue;
            selectedItems.add(item);
        }
        this.table.setTopIndex(topIndex);
        this.table.setSelection(selectedItems.toArray(new TableItem[selectedItems.size()]));
        this.table.redraw();
    }

    @Override
    public Section getSection() {
        return this.section;
    }

    @Override
    public double getPriority() {
        return 100.0;
    }

    @Override
    public Object getSectionSpecificData(ReadGraph graph, ComponentTypeViewerPropertyInfo info) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(info.resource, L0.HasRange);
        if (range != null && graph.isInstanceOf(range, STR.MonitorValueType)) {
            return MONITOR;
        }
        return null;
    }

    @Override
    public double getDataPriority() {
        return 100.0;
    }
}

