/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.internal;

import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.district.route.RouteService;
import org.simantics.district.route.Router;
import org.simantics.district.route.internal.RouteServiceImpl;

public class Activator
implements BundleActivator,
ServiceListener {
    private static BundleContext context;
    private static Activator instance;
    private RouteServiceImpl routeService;
    private ServiceRegistration<?> routeServiceRegistration;
    private ServiceTracker<RouteService, ?> routeServiceTracker;
    private ServiceTracker<Router, ?> routerTracker;

    static BundleContext getContext() {
        return context;
    }

    public static Activator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        instance = this;
        Activator.context = context;
        this.routeService = new RouteServiceImpl();
        this.routeServiceRegistration = context.registerService(RouteService.class.getName(), (Object)this.routeService, new Hashtable());
        this.routeServiceTracker = new ServiceTracker(context, RouteService.class.getName(), null);
        this.routeServiceTracker.open();
        this.routerTracker = new ServiceTracker(context, Router.class.getName(), null);
        this.routerTracker.open();
        Object[] routers = this.routerTracker.getServices();
        if (routers != null) {
            Object[] objectArray = routers;
            int n = routers.length;
            int n2 = 0;
            while (n2 < n) {
                Object router = objectArray[n2];
                this.routeService.registerRouter((Router)router);
                ++n2;
            }
        }
        context.addServiceListener((ServiceListener)this, "(objectClass=" + Router.class.getName() + ")");
        this.routeService = (RouteServiceImpl)this.routeServiceTracker.getService();
    }

    public void stop(BundleContext context) throws Exception {
        this.routeServiceTracker.close();
        this.routeServiceTracker = null;
        this.routeServiceRegistration.unregister();
        this.routeService.close();
        this.routeService = null;
        context = null;
        instance = null;
    }

    public void serviceChanged(ServiceEvent ev) {
        ServiceReference sr = ev.getServiceReference();
        switch (ev.getType()) {
            case 1: {
                this.routeService.registerRouter((Router)context.getService(sr));
                break;
            }
            case 4: {
                this.routeService.unregisterRouter((Router)context.getService(sr));
            }
        }
    }

    public RouteService getRouteService() {
        return this.routeService;
    }
}

