/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.internal.startup;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.internal.startup.StartupExtension;

public class StartupRegistry
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics";
    private static final String EP_NAME = "startup";
    private static final String STARTUP = "startup";
    private final ExtensionTracker tracker;
    private StartupExtension[] extensions = new StartupExtension[0];

    public StartupRegistry() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, "startup");
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private void loadExtensions(IConfigurationElement[] configurationElements) {
        HashSet<StartupExtension> newExtensions = new HashSet<StartupExtension>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            String clazz;
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("startup".equals(el.getName()) && (clazz = el.getAttribute("class")) != null) {
                StartupExtension ext = new StartupExtension(el);
                this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                newExtensions.add(ext);
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new StartupExtension[newExtensions.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<StartupExtension> newExtensions = new HashSet<StartupExtension>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new StartupExtension[newExtensions.size()]);
    }

    public StartupExtension[] getExtensions() {
        return this.extensions;
    }
}

