/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.internal;

import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.simantics.db.Disposable;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.datastructures.cache.SoftTimedCache;
import org.simantics.utils.datastructures.disposable.IDisposable;

public class TimedSessionCache
extends SoftTimedCache<Object, ISessionContext> {
    private static ServiceRegistration<?> service = null;
    private static BundleContext bundleContext = null;
    private static boolean disposed = false;

    TimedSessionCache() {
        super("Database Session Cache Timer");
    }

    public static synchronized void initialize(BundleContext context) {
        bundleContext = context;
        service = context.registerService(TimedSessionCache.class.getName(), (Object)new TimedSessionCache(), new Hashtable());
        disposed = false;
    }

    public static synchronized void close() {
        if (service != null) {
            TimedSessionCache cache = TimedSessionCache.getCache();
            cache.clear();
            service.unregister();
            service = null;
            disposed = true;
        }
        bundleContext = null;
    }

    public static synchronized TimedSessionCache getCache() {
        if (disposed) {
            throw new IllegalStateException("cache service is disposed");
        }
        if (service == null) {
            throw new IllegalStateException("cache service not initialized");
        }
        return (TimedSessionCache)((Object)bundleContext.getService(service.getReference()));
    }

    protected void disposeValue(ISessionContext v) {
        super.disposeValue((Object)v);
        if (v instanceof IDisposable) {
            v.safeDispose();
        } else if (v instanceof Disposable) {
            ((Disposable)v).dispose();
        }
    }
}

