/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.utils.FileService;
import org.simantics.utils.IOperation;
import org.simantics.utils.IOperationListener;

public class FileServiceImpl
implements FileService {
    private static final long DELETION_DELAY_MS = 10000L;
    private static final long DELETION_ATTEMPT_INTERVAL_MS = 10000L;
    private ArrayDeque<Deletion> deletionQueue = new ArrayDeque();
    private DeletionJob deletionJob = new DeletionJob();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOperation<Boolean, IOException> scheduleDeleteIfExists(File file, FileService.DeleteOption ... options) {
        if (!file.exists()) {
            return null;
        }
        ArrayDeque<Deletion> arrayDeque = this.deletionQueue;
        synchronized (arrayDeque) {
            Deletion d;
            block5: {
                d = new Deletion(file, options);
                if (!this.deletionQueue.contains(d)) break block5;
                return null;
            }
            this.deletionQueue.addLast(d);
            this.deletionJob.schedule(10000L);
            return d;
        }
    }

    private static class Deletion
    extends Op<Boolean, IOException> {
        File f;
        FileService.EffortOption effort;
        int tries;

        public Deletion(File f, FileService.DeleteOption ... options) {
            this.f = f;
            this.parseOptions(options);
        }

        private void parseOptions(FileService.DeleteOption[] options) {
            FileService.DeleteOption[] deleteOptionArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                FileService.DeleteOption opt = deleteOptionArray[n2];
                if (opt instanceof FileService.EffortOption) {
                    this.effort = (FileService.EffortOption)opt;
                }
                ++n2;
            }
        }

        @Override
        public boolean tryExecute() {
            if (this.effort != null && this.tries > this.effort.maxTries) {
                return true;
            }
            try {
                this.deleteAll(this.f);
                this.lastException = null;
                this.result = true;
                return true;
            }
            catch (IOException e) {
                ++this.tries;
                this.lastException = e;
                return false;
            }
        }

        public void deleteAll(File dir) throws IOException {
            if (dir.isFile()) {
                if (!dir.delete()) {
                    throw new IOException("Could not delete file: " + dir.getAbsolutePath());
                }
                return;
            }
            if (dir.isDirectory()) {
                File[] fs = dir.listFiles((FileFilter)null);
                if (fs == null) {
                    return;
                }
                File[] fileArray = fs;
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        this.deleteAll(f);
                    } else if (!f.delete()) {
                        throw new IOException("Could not delete file: " + f.getAbsolutePath());
                    }
                    ++n2;
                }
                if (!dir.delete()) {
                    throw new IOException("Could not delete directory: " + dir.getAbsolutePath());
                }
            } else if (dir.exists() && !dir.delete()) {
                throw new IOException("Could not delete file: " + dir.getAbsolutePath());
            }
        }
    }

    class DeletionJob
    extends Job {
        public DeletionJob() {
            super("File background deletion");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <O extends Op<?, ?>> void process(Collection<O> ops) {
            Object[] opa = ops.toArray();
            int i = 0;
            while (i < opa.length) {
                Op op = (Op)opa[i];
                if (!op.tryExecute()) {
                    opa[i] = null;
                }
                ++i;
            }
            Collection<O> collection = ops;
            synchronized (collection) {
                int i2 = 0;
                while (i2 < opa.length) {
                    if (opa[i2] != null) {
                        ops.remove(opa[i2]);
                    }
                    ++i2;
                }
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.process(FileServiceImpl.this.deletionQueue);
            if (!FileServiceImpl.this.deletionQueue.isEmpty()) {
                this.schedule(10000L);
            }
            return Status.OK_STATUS;
        }
    }

    private static abstract class Op<R, E extends Exception>
    implements IOperation<R, E> {
        protected boolean done;
        protected R result;
        protected E lastException;

        private Op() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public R waitFor() throws E {
            Op op = this;
            synchronized (op) {
                while (true) {
                    if (this.isDone()) {
                        return this.result;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public void addListener(IOperationListener<R, E> listener) {
            throw new UnsupportedOperationException();
        }

        public abstract boolean tryExecute();
    }
}

