/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import org.simantics.db.Resource;
import org.simantics.platform.ui.PlatformUIResource;

public enum NameLabelMode {
    NAME("Name"),
    LABEL("Label"),
    NAME_AND_LABEL("Name (Label)"),
    LABEL_AND_NAME("Label (Name)");

    private String label;

    private NameLabelMode(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public NameLabelMode cycle() {
        if (NAME == this) {
            return LABEL;
        }
        if (LABEL == this) {
            return NAME_AND_LABEL;
        }
        if (NAME_AND_LABEL == this) {
            return LABEL_AND_NAME;
        }
        return NAME;
    }

    public Resource asResource(PlatformUIResource UI) {
        if (NAME == this) {
            return UI.NameLabelMode_Name;
        }
        if (LABEL == this) {
            return UI.NameLabelMode_Label;
        }
        if (LABEL_AND_NAME == this) {
            return UI.NameLabelMode_LabelAndName;
        }
        return UI.NameLabelMode_NameAndLabel;
    }

    public static NameLabelMode fromString(String value) {
        if (value == null) {
            return NameLabelMode.getDefault();
        }
        return NameLabelMode.valueOf(value);
    }

    public static NameLabelMode getDefault() {
        return NAME_AND_LABEL;
    }
}

