/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildInfo.class);
    private static final Properties PROPS;
    private static final String ALL;
    public static final String DEFAULT_BUILDINFO_PROPERTIES_FILE = "buildinfo.properties";
    public static final String BUILDINFO_PROPERTIES_PROP = "buildinfo.properties.location";
    public static final String BUILD_INFO_PROPERTIES_FILE;

    static {
        BUILD_INFO_PROPERTIES_FILE = System.getProperty(BUILDINFO_PROPERTIES_PROP, DEFAULT_BUILDINFO_PROPERTIES_FILE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to load build information from {}", (Object)BUILD_INFO_PROPERTIES_FILE);
        }
        Properties buildinfo = new Properties();
        Path propertiesFile = Paths.get(BUILD_INFO_PROPERTIES_FILE, new String[0]);
        if (Files.exists(propertiesFile, new LinkOption[0])) {
            try {
                buildinfo.load(Files.newInputStream(propertiesFile, new OpenOption[0]));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(buildinfo.toString());
                }
            }
            catch (IOException e) {
                LOGGER.error("Could not load build information from {}", (Object)propertiesFile.toAbsolutePath(), (Object)e);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Build information not loaded as {} does not exist", (Object)propertiesFile.toAbsolutePath());
        }
        BuildInfo.collectInformationFromActiveProduct(buildinfo);
        PROPS = buildinfo;
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> orderedProps = new TreeMap<String, String>((o1, o2) -> o1.compareTo((String)o2));
        for (Map.Entry<Object, Object> entry : PROPS.entrySet()) {
            orderedProps.put(entry.getKey().toString(), entry.getValue().toString());
        }
        for (Map.Entry<Object, Object> entry : orderedProps.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("\n");
        }
        ALL = sb.toString();
    }

    private static void collectInformationFromActiveProduct(Properties buildinfo) {
        IProduct product = Platform.getProduct();
        if (product != null) {
            String productName = product.getName() != null ? product.getName() : "<not-set>";
            String productApplication = product.getApplication() != null ? product.getApplication() : "<not-set>";
            String productDescription = product.getDescription() != null ? product.getDescription() : "<not-set>";
            String productId = product.getId() != null ? product.getId() : "<not-set>";
            buildinfo.setProperty("product.name", productName);
            buildinfo.setProperty("product.application", productApplication);
            buildinfo.setProperty("product.description", productDescription);
            buildinfo.setProperty("product.id", productId);
        }
    }

    public static String get(String key) {
        return PROPS.getProperty(key, "<not-set>");
    }

    public static String all() {
        return ALL;
    }

    public static Map<String, String> asMap() {
        return PROPS.entrySet().stream().collect(Collectors.toMap(k -> String.valueOf(k), v -> String.valueOf(v)));
    }
}

