/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.internal;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.simantics.internal.startup.StartupRegistry;

public class Activator
extends Plugin {
    public static String LOG_FILE_NAME = "simantics.log";
    public static final String PLUGIN_ID = "org.simantics";
    private static Activator plugin;
    private static BundleContext context;
    private StartupRegistry startupRegistry;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        block7: {
            super.start(bundleContext);
            context = bundleContext;
            plugin = this;
            String prop = System.getProperty("osgi.instance.area", null);
            if (prop != null) {
                try {
                    URL url = new URL(prop);
                    if (!"file".equals(url.getProtocol())) break block7;
                    try {
                        File logFile;
                        File path = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
                        if (!path.exists()) {
                            path.mkdirs();
                        }
                        if (path.exists() && path.canWrite() && (!(logFile = new File(path, LOG_FILE_NAME)).exists() || logFile.isFile() && logFile.canWrite())) {
                            LOG_FILE_NAME = logFile.getAbsolutePath();
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        this.startupRegistry = new StartupRegistry();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        plugin = null;
        super.stop(bundleContext);
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public StartupRegistry getStartupRegistry() {
        return this.startupRegistry;
    }
}

