/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.simantics.Messages;
import org.simantics.PlatformException;
import org.simantics.UnsupportedWorkspaceVersionException;
import org.simantics.utils.strings.EString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workspaces {
    private static final Logger LOGGER = LoggerFactory.getLogger(Workspaces.class);
    public static final String DEFAULT_VERSION_FILE = ".version";

    public static Path getWorkspacePath() {
        IPath finalPath = Platform.getLocation();
        if (finalPath == null) {
            throw new IllegalStateException(Messages.Workspaces_CannotResolveWorkspacePathError);
        }
        return finalPath.toFile().toPath();
    }

    private static String incompatibleWorkpaceMessage(Path ws, String expectedVersion, String gotVersion) {
        return NLS.bind((String)Messages.Workspaces_IncompatibleWorkspaceVersionError, (Object[])new Object[]{ws.toAbsolutePath().toString(), expectedVersion, gotVersion});
    }

    public static void assertWorkspaceVersion(String ... expectedVersionDescriptor) throws PlatformException {
        Path ws = Workspaces.getWorkspacePath();
        Path ver = ws.resolve(DEFAULT_VERSION_FILE);
        Workspaces.assertWorkspaceVersion(ws, ver, expectedVersionDescriptor);
    }

    public static void assertWorkspaceVersion(Path workspace, Path versionFile, String ... expectedVersionDescriptor) throws PlatformException {
        try {
            String error = Workspaces.validateWorkspaceVersion(workspace, versionFile, expectedVersionDescriptor);
            if (error != null) {
                throw new UnsupportedWorkspaceVersionException(error);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed o validate workspace {} version file {} with expected version {}", new Object[]{workspace, versionFile, Arrays.toString(expectedVersionDescriptor), e});
            throw new UnsupportedWorkspaceVersionException("Unexpected I/O exception while checking workspace version information. Cannot safely commence program startup.", e);
        }
    }

    public static String validateWorkspaceVersion(Path workspace, Path versionFile, String ... expectedVersionDescriptor) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        try {
            List<String> lines = Files.readAllLines(versionFile, charset);
            boolean ok = true;
            if (lines.size() >= expectedVersionDescriptor.length) {
                int i = 0;
                while (i < expectedVersionDescriptor.length) {
                    String expected;
                    String got = lines.get(i);
                    if (!got.equals(expected = expectedVersionDescriptor[i])) {
                        ok = false;
                        break;
                    }
                    ++i;
                }
            } else {
                ok = false;
            }
            return ok ? null : Workspaces.incompatibleWorkpaceMessage(workspace, EString.implode((Object[])expectedVersionDescriptor, (String)"\n"), EString.implode(lines, (String)"\n"));
        }
        catch (NoSuchFileException noSuchFileException) {
            Files.write(versionFile, Arrays.asList(expectedVersionDescriptor), charset, new OpenOption[0]);
            return null;
        }
    }
}

