/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.VirtualGraphSupport;

public class AutosaveVirtualGraphs
extends Job {
    private static final boolean TRACE = false;
    private boolean enabled = true;
    private Preferences defaultPrefs = DefaultScope.INSTANCE.getNode("org.simantics");
    private Preferences prefs = InstanceScope.INSTANCE.getNode("org.simantics");
    private static AutosaveVirtualGraphs INSTANCE;

    private boolean getBooleanPref(String preference, boolean def) {
        return this.prefs.getBoolean(preference, this.defaultPrefs.getBoolean(preference, def));
    }

    private int getIntPref(String preference, int def) {
        return this.prefs.getInt(preference, this.defaultPrefs.getInt(preference, def));
    }

    private AutosaveVirtualGraphs() {
        super("Autosave Virtual Graphs");
        this.setSystem(true);
        this.setPriority(30);
    }

    public static synchronized AutosaveVirtualGraphs getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutosaveVirtualGraphs();
        }
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return enabled;
        }
        this.enabled = enabled;
        if (enabled) {
            this.scheduleAfterInterval();
        } else {
            this.cancel();
        }
        return !enabled;
    }

    public AutosaveVirtualGraphs scheduleAfterInterval() {
        String enabled = System.getProperty("db.vg.autosave");
        if (enabled != null && enabled.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return this;
        }
        if (!this.getBooleanPref("virtualgraph.autosave.enabled", true)) {
            return this;
        }
        this.wakeUp();
        int interval = this.getIntPref("virtualgraph.autosave.interval", 90);
        this.schedule((long)interval * 1000L);
        return this;
    }

    public boolean shouldSchedule() {
        return this.enabled;
    }

    public boolean shouldRun() {
        return this.enabled;
    }

    protected IStatus runHeadless(IProgressMonitor monitor) {
        try {
            Session session = Simantics.peekSession();
            if (session == null) {
                return Status.CANCEL_STATUS;
            }
            LifecycleSupport lfs = (LifecycleSupport)session.peekService(LifecycleSupport.class);
            if (lfs == null || lfs.isClosed() || lfs.isClosing()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Autosaving virtual graphs...", -1);
            long startTime = System.nanoTime();
            session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    AutosaveVirtualGraphs.doSave(graph);
                }
            });
            return Status.OK_STATUS;
        }
        catch (DatabaseException e) {
            return new Status(4, "org.simantics", "Autosaving virtual graphs failed", (Throwable)e);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.getBooleanPref("virtualgraph.autosave.enabled", true)) {
            return Status.OK_STATUS;
        }
        int interval = this.getIntPref("virtualgraph.autosave.interval", 90);
        try {
            if (DatabaseJob.inProgress()) {
                interval = Math.min(10, interval);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = this.runHeadless(monitor);
            return iStatus;
        }
        finally {
            this.schedule((long)interval * 1000L);
        }
    }

    public static void doSave(ReadGraph graph) throws DatabaseException {
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        vgs.saveAll();
    }

    public static void saveVirtualGraphsPeriodically() {
        AutosaveVirtualGraphs.getInstance().scheduleAfterInterval();
    }
}

