/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoHistoryException;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class SessionUndoHandler
extends AbstractHandler {
    private final boolean DEBUG = false;
    private final boolean ENABLED = true;

    public Object execute(ExecutionEvent e) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)e);
        if (part == null) {
            return null;
        }
        IActionBars actionBars = WorkbenchUtils.getActionBars((IWorkbenchPart)part);
        final Session session = Simantics.peekSession();
        if (session == null) {
            return null;
        }
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.simantics.ui.states.trackedText");
        State state = command.getState("org.simantics.ui.states.trackedText.state");
        boolean sessionUndoEnabled = true;
        Object value = state.getValue();
        if (value != null && value instanceof Boolean) {
            sessionUndoEnabled = (Boolean)value;
        }
        if (sessionUndoEnabled) {
            try {
                final AtomicReference msg = new AtomicReference();
                IRunnableWithProgress undo = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask("Undo", -1);
                                msg.set(SessionUndoHandler.this.undo(session));
                            }
                            catch (NoHistoryException noHistoryException) {
                                msg.set("Nothing to undo.");
                                monitor.done();
                            }
                            catch (DatabaseException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                new ProgressMonitorDialog(shell).run(true, false, undo);
                actionBars.getStatusLineManager().setMessage((String)msg.get());
            }
            catch (InvocationTargetException e1) {
                throw new ExecutionException("Undo failed, database failure.", e1.getCause());
            }
            catch (InterruptedException e1) {
                throw new ExecutionException("Undo failed, interrupted.", (Throwable)e1);
            }
        }
        return null;
    }

    public static String getComment(Session session, ChangeSetIdentifier id) {
        byte[] data = (byte[])id.getMetadata().get(CommentMetadata.class.getName());
        if (data == null) {
            return "Undescribed operation.";
        }
        String comment = CommentMetadata.deserialise((Session)session, (byte[])data).toString().trim();
        if (comment.isEmpty()) {
            return "Undescribed operation.";
        }
        return comment;
    }

    private String undo(Session session) throws DatabaseException {
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.undoAndReturnOperations(session, 1);
        if (ops.isEmpty()) {
            return "Undo history is empty.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        String msg = null;
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        for (ChangeSetIdentifier id : management.getChangeSetIdentifiers(csId, csId)) {
            if (msg != null) continue;
            msg = "Undo reverted: " + SessionUndoHandler.getComment(session, id);
        }
        return msg;
    }
}

