/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.editor.input;

import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.request.Read;
import org.simantics.ui.workbench.IResourceEditorInput;

public final class InputValidationCombinators {
    private static final ParametrizedRead<IResourceEditorInput, Resource> EXTRACT_INPUT_RESOURCE = new ParametrizedRead<IResourceEditorInput, Resource>(){

        public Read<Resource> get(IResourceEditorInput input) {
            return InputValidationCombinators.extractResource(input);
        }
    };
    private static final ParametrizedRead<Resource, Boolean> HAS_URI = new ParametrizedRead<Resource, Boolean>(){

        public Read<Boolean> get(Resource resource) {
            return InputValidationCombinators.hasURI(resource);
        }
    };

    public static ParametrizedRead<Resource, Boolean> hasURI() {
        return HAS_URI;
    }

    public static ParametrizedRead<IResourceEditorInput, Resource> extractInputResource() {
        return EXTRACT_INPUT_RESOURCE;
    }

    public static ParametrizedRead<Resource, Resource> completeFunction(String relationURI) {
        return new CompleteFunctionURI(relationURI);
    }

    public static ParametrizedRead<Resource, Resource> partialFunction(String relationURI) {
        return new PartialFunctionURI(relationURI);
    }

    public static ParametrizedRead<Resource, Boolean> or(ParametrizedRead<Resource, Boolean> c1, ParametrizedRead<Resource, Boolean> c2) {
        return new FunctionOr(c1, c2);
    }

    public static Read<Boolean> hasURI(Resource resource) {
        return new HasURI(resource);
    }

    public static Read<Resource> extractResource(IResourceEditorInput input) {
        return new ExtractResource(input);
    }

    public static Read<Resource> possibleObject(Resource subject, String relationURI) {
        return new PossibleObjectURI(subject, relationURI);
    }

    public static Read<Resource> singleObject(Resource subject, String relationURI) {
        return new SingleObjectURI(subject, relationURI);
    }

    private static class CompleteFunctionURI
    implements ParametrizedRead<Resource, Resource> {
        String relationURI;

        public CompleteFunctionURI(String relationURI) {
            this.relationURI = relationURI;
        }

        public Read<Resource> get(Resource subject) {
            if (subject == null) {
                return Combinators.constant(null);
            }
            return InputValidationCombinators.singleObject(subject, this.relationURI);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * this.relationURI.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CompleteFunctionURI other = (CompleteFunctionURI)obj;
            return this.relationURI.equals(other.relationURI);
        }
    }

    private static class ExtractResource
    extends UnaryRead<IResourceEditorInput, Resource> {
        public ExtractResource(IResourceEditorInput input) {
            super((Object)input);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            return this.parameter != null ? ((IResourceEditorInput)this.parameter).getResource() : null;
        }
    }

    private static class FunctionOr
    implements ParametrizedRead<Resource, Boolean> {
        ParametrizedRead<Resource, Boolean>[] reads;

        public FunctionOr(ParametrizedRead<Resource, Boolean> ... reads) {
            this.reads = reads;
        }

        public Read<Boolean> get(Resource subject) {
            if (subject == null || this.reads.length == 0) {
                return Combinators.constant((Object)Boolean.TRUE);
            }
            return new Or(subject, this.reads);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * Arrays.hashCode(this.reads);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FunctionOr other = (FunctionOr)obj;
            return Arrays.equals(this.reads, other.reads);
        }
    }

    private static class HasURI
    extends UnaryRead<Resource, Boolean> {
        public HasURI(Resource resource) {
            super((Object)resource);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            if (this.parameter == null) {
                return Boolean.FALSE;
            }
            String uri = (String)graph.syncRequest(Queries.possibleUri((Resource)((Resource)this.parameter)));
            if (uri == null) {
                return Boolean.FALSE;
            }
            Resource reverseLookup = graph.getPossibleResource(uri);
            return ((Resource)this.parameter).equals(reverseLookup);
        }
    }

    private static class Or
    extends UnaryRead<Resource, Boolean> {
        ParametrizedRead<Resource, Boolean>[] reads;

        public Or(Resource resource, ParametrizedRead<Resource, Boolean> ... reads) {
            super((Object)resource);
            this.reads = reads;
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            ParametrizedRead<Resource, Boolean>[] parametrizedReadArray = this.reads;
            int n = this.reads.length;
            int n2 = 0;
            while (n2 < n) {
                ParametrizedRead<Resource, Boolean> r = parametrizedReadArray[n2];
                Read read = r.get((Object)((Resource)this.parameter));
                Boolean value = (Boolean)graph.syncRequest(read);
                if (value.booleanValue()) {
                    return Boolean.TRUE;
                }
                ++n2;
            }
            return Boolean.FALSE;
        }

        public int hashCode() {
            return super.hashCode() * 31 + Arrays.hashCode(this.reads);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            Or other = (Or)((Object)object);
            return super.equals(object) && Arrays.equals(this.reads, other.reads);
        }
    }

    private static class PartialFunctionURI
    implements ParametrizedRead<Resource, Resource> {
        String relationURI;

        public PartialFunctionURI(String relationURI) {
            this.relationURI = relationURI;
        }

        public Read<Resource> get(Resource subject) {
            if (subject == null) {
                return Combinators.constant(null);
            }
            return InputValidationCombinators.possibleObject(subject, this.relationURI);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * this.relationURI.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PartialFunctionURI other = (PartialFunctionURI)obj;
            return this.relationURI.equals(other.relationURI);
        }
    }

    private static class PossibleObjectURI
    implements Read<Resource> {
        Resource subject;
        String relationURI;

        public PossibleObjectURI(Resource subject, String relationURI) {
            this.subject = subject;
            this.relationURI = relationURI;
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            Resource relation = graph.getResource(this.relationURI);
            return graph.getPossibleObject(this.subject, relation);
        }

        public int hashCode() {
            return this.subject.hashCode() + 31 * this.relationURI.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PossibleObjectURI other = (PossibleObjectURI)object;
            return this.subject.equals(other.subject) && this.relationURI.equals(other.relationURI);
        }
    }

    private static class SingleObjectURI
    implements Read<Resource> {
        Resource subject;
        String relationURI;

        public SingleObjectURI(Resource subject, String relationURI) {
            this.subject = subject;
            this.relationURI = relationURI;
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            Resource relation = graph.getResource(this.relationURI);
            return graph.getSingleObject(this.subject, relation);
        }

        public int hashCode() {
            return this.subject.hashCode() + 31 * this.relationURI.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SingleObjectURI other = (SingleObjectURI)object;
            return this.subject.equals(other.subject) && this.relationURI.equals(other.relationURI);
        }
    }
}

