/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.Prioritized;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public abstract class AbstractEditorAdapter
implements EditorAdapter,
Prioritized {
    protected String name;
    protected ImageDescriptor icon;
    protected int priority;

    public AbstractEditorAdapter(String name) {
        this(name, null, 0);
    }

    public AbstractEditorAdapter(String name, ImageDescriptor icon) {
        this(name, icon, 0);
    }

    public AbstractEditorAdapter(String name, ImageDescriptor icon, int priority) {
        this.name = name;
        this.icon = icon;
        this.priority = priority;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.icon;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected void setIcon(ImageDescriptor icon) {
        this.icon = icon;
    }

    protected void openEditorWithId(String editorId, IEditorInput input) throws PartInitException {
        WorkbenchUtils.openEditor((String)editorId, (IEditorInput)input);
    }

    protected void openEditorWithIdInPerspective(String editorId, IEditorInput input, String perspectiveId) throws WorkbenchException {
        try {
            WorkbenchUtils.showPerspective((String)perspectiveId);
        }
        catch (WorkbenchException e) {
            ErrorLogger.getDefault().logError("Could not open perspective with ID'" + perspectiveId + "'.", (Throwable)e);
        }
        this.openEditorWithId(editorId, input);
    }
}

