/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.e4;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.e4.E4ResourceEditorInput;

public class E4ResourceEditorInput2
extends E4ResourceEditorInput
implements IResourceEditorInput2 {
    protected final Resource model;
    protected final String rvi;
    protected transient Variable variable;

    public E4ResourceEditorInput2(Resource resource, Resource model, String rvi) {
        super(resource);
        this.model = model;
        this.rvi = rvi;
    }

    @Override
    public void dispose() {
        this.variable = null;
    }

    @Override
    public Resource getModel(ReadGraph graph) {
        return this.model;
    }

    @Override
    public String getRVI() {
        return this.rvi;
    }

    @Override
    public boolean exists(ReadGraph graph) throws DatabaseException {
        boolean modelExists;
        if (!super.exists(graph)) {
            return false;
        }
        if (this.model != null && !(modelExists = graph.hasStatement(this.model))) {
            return false;
        }
        if (this.rvi != null) {
            Variable context = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)this.model);
            if (context == null) {
                return false;
            }
            RVI rvi_ = RVI.fromResourceFormat((RequestProcessor)graph, (String)this.rvi);
            Variable variable = rvi_.resolvePossible(graph, context);
            if (variable == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Variable getVariable() throws DatabaseException {
        if (this.variable != null) {
            return this.variable;
        }
        return (Variable)Simantics.getSession().syncRequest((Read)new UniqueRead<Variable>(){

            public Variable perform(ReadGraph graph) throws DatabaseException {
                return E4ResourceEditorInput2.this.getVariable(graph);
            }
        });
    }

    protected Variable getVariable0(ReadGraph graph) throws DatabaseException {
        Resource model = this.getModel(graph);
        String rvi = this.getRVI();
        if (rvi != null) {
            Variable configuration = Variables.getConfigurationContext((ReadGraph)graph, (Resource)model);
            RVI rrvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)rvi);
            return rrvi.resolve(graph, configuration);
        }
        return Variables.getVariable((ReadGraph)graph, (Resource)model);
    }

    @Override
    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        Variable v;
        this.variable = v = this.getVariable0(graph);
        return v;
    }
}

