/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.e4;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Composite;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.e4.E4ResourceEditorInput;
import org.simantics.ui.workbench.e4.E4ResourceEditorInput2;
import org.simantics.ui.workbench.e4.E4ResourceEditorSupport;

public abstract class E4ResourceEditorBase {
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IEclipseContext eclipseContext;
    private MPart part;
    private boolean disposed;
    private Resource resource;
    private Variable variable;
    private String rvi;
    private Resource model;
    private IResourceEditorInput input;
    private E4ResourceEditorSupport support;

    @Inject
    public final void init(MPart mPart) throws NumberFormatException, DatabaseException {
        this.part = mPart;
        this.readTransientState();
        if (this.resource == null && this.model == null && this.rvi == null && this.variable == null) {
            this.readPersistentState();
        }
        this.deriveState();
        this.initImpl(this.part);
        if (!this.part.getTags().contains("removeOnHide")) {
            this.part.getTags().add("removeOnHide");
        }
    }

    public void initImpl(MPart part) {
    }

    private void deriveState() throws DatabaseException {
        boolean deriveModel;
        final boolean deriveVariable = this.variable == null && this.model != null;
        final boolean deriveModelAndRVI = this.variable != null;
        boolean bl = deriveModel = this.resource != null && this.model == null;
        if (deriveModel || deriveModelAndRVI || deriveVariable) {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    if (deriveVariable) {
                        if (E4ResourceEditorBase.this.rvi != null) {
                            Variable configuration = Variables.getConfigurationContext((ReadGraph)graph, (Resource)E4ResourceEditorBase.this.model);
                            RVI rrvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)E4ResourceEditorBase.this.rvi);
                            E4ResourceEditorBase.this.variable = rrvi.resolve(graph, configuration);
                        } else {
                            E4ResourceEditorBase.this.variable = Variables.getVariable((ReadGraph)graph, (Resource)E4ResourceEditorBase.this.model);
                        }
                    }
                    if (deriveModelAndRVI) {
                        E4ResourceEditorBase.this.model = Variables.getPossibleModel((ReadGraph)graph, (Variable)E4ResourceEditorBase.this.variable);
                        E4ResourceEditorBase.this.rvi = E4ResourceEditorBase.this.variable.getRVI(graph).toString();
                    }
                    if (deriveModel) {
                        E4ResourceEditorBase.this.model = (Resource)graph.syncRequest((Read)new PossibleModel(E4ResourceEditorBase.this.resource));
                    }
                }
            });
        }
        Map transientData = this.part.getTransientData();
        transientData.put("keyResource", this.resource);
        transientData.put("keyModel", this.model);
        transientData.put("keyVariable", this.variable);
        transientData.put("keyRVI", this.rvi);
        if (this.resource != null) {
            this.input = this.model != null ? new E4ResourceEditorInput2(this.resource, this.model, this.rvi) : new E4ResourceEditorInput(this.resource);
        }
    }

    protected void activateValidation() {
        this.support = new E4ResourceEditorSupport(this, this.getInputValidator());
        this.support.activateValidation();
    }

    protected void deactivateValidation() {
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
    }

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return null;
    }

    private void readTransientState() throws DatabaseException {
        Object inputVariable;
        Object inputModel;
        Object inputRVI;
        Map transientData = this.part.getTransientData();
        Object inputResource = transientData.get("keyResource");
        if (inputResource != null && inputResource instanceof Resource) {
            this.resource = (Resource)inputResource;
        }
        if ((inputRVI = transientData.get("keyRVI")) != null && inputRVI instanceof String) {
            this.rvi = (String)inputRVI;
        }
        if ((inputModel = transientData.get("keyModel")) != null && inputModel instanceof Resource) {
            this.model = (Resource)inputModel;
        }
        if ((inputVariable = transientData.get("keyVariable")) != null && inputVariable instanceof Variable) {
            this.variable = (Variable)inputVariable;
        }
    }

    private void readPersistentState() throws NumberFormatException, DatabaseException {
        String inputModel;
        String inputRVI;
        Map persistState = this.part.getPersistedState();
        SerialisationSupport support = (SerialisationSupport)Simantics.getSession().getService(SerialisationSupport.class);
        String inputResource = (String)persistState.get("keyResource");
        if (inputResource != null) {
            this.resource = support.getResource(Long.parseLong(inputResource));
        }
        if ((inputRVI = (String)persistState.get("keyRVI")) != null) {
            this.rvi = inputRVI;
        }
        if ((inputModel = (String)persistState.get("keyModel")) != null) {
            this.model = support.getResource(Long.parseLong(inputModel));
        }
    }

    @PostConstruct
    public void createEditor(Composite parent) {
        this.createPartControl(parent);
    }

    public abstract void createPartControl(Composite var1);

    @PersistState
    public void persistState() {
        System.out.println("persistState");
        Map persistedState = this.part.getPersistedState();
        if (this.resource != null) {
            persistedState.put("keyResource", Long.toString(this.resource.getResourceId()));
        }
        if (this.model != null) {
            persistedState.put("keyModel", Long.toString(this.model.getResourceId()));
        }
        if (this.rvi != null) {
            persistedState.put("keyRVI", this.rvi);
        }
    }

    @Persist
    public void persist() {
        System.out.println("persist");
    }

    @PreDestroy
    public void preDestroy() {
        System.out.println("dispose");
        this.disposed = true;
        this.dispose();
        this.deactivateValidation();
    }

    public abstract void dispose();

    public boolean isDisposed() {
        return this.disposed;
    }

    public abstract void setFocus();

    @Focus
    public void focus() {
        this.setFocus();
    }

    public MPart getPart() {
        return this.part;
    }

    public Resource getInputResource() {
        return this.resource;
    }

    public Variable getInputVariable() {
        return this.variable;
    }

    public String getInputRVI() {
        return this.rvi;
    }

    public Resource getInputModelResource() {
        return this.model;
    }

    public Resource assertInputModelResource() {
        if (this.model == null) {
            throw new NullPointerException("Input model resource not defined, input resource is " + String.valueOf(this.resource));
        }
        return this.model;
    }

    public IResourceEditorInput getResourceInput() {
        return this.input;
    }

    public ESelectionService getSelectionService() {
        return this.selectionService;
    }

    public IEclipseContext getContext() {
        return this.eclipseContext;
    }
}

