/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.dialogs;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.ui.workbench.dialogs.ElementListSelectionDialog;

public class ResourceListDialog
extends ElementListSelectionDialog {
    public static final String DEFAULT_LABEL_SUFFIX = " (? = any character, * = any String)";

    public ResourceListDialog(Shell parent, ILabelProvider labelProvider) {
        super(parent, labelProvider);
    }

    public ResourceListDialog(Shell parent, String title, String label, ILabelProvider labelProvider) {
        this(parent, labelProvider);
        this.setTitle(title);
        this.setMessage(label);
    }

    public ResourceListDialog(Shell parent, String title, ILabelProvider labelProvider) {
        this(parent, labelProvider);
        this.setTitle(title);
        this.setMessage(title + DEFAULT_LABEL_SUFFIX);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }

    public Resource[] getResultResources() {
        Object[] res = this.getResult();
        Resource[] result = new Resource[res.length];
        int i = 0;
        while (i < res.length) {
            result[i] = (Resource)res[i];
            ++i;
        }
        return result;
    }

    public Resource getSingleResultResource() {
        return (Resource)this.getSingleResult();
    }

    public Object getSingleResult() {
        Object[] res = this.getResult();
        if (res == null) {
            return null;
        }
        if (res.length != 1) {
            return null;
        }
        return res[0];
    }
}

