/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.simantics.ui.workbench.dialogs.PrioritizeComparator;

public class ElementListSelectionDialog
extends AbstractElementListSelectionDialog {
    protected static final int REMEMBER_NUM = 128;
    protected static final int PRIORITIZE_NUM = 5;
    protected String title = "";
    protected List<Object> elementList = new ArrayList<Object>();
    protected ILabelProvider labelProvider;
    protected boolean usePreviousSelectionSort = true;
    protected Label messageLabel;
    protected Text filterText;
    protected static Map<String, List<Integer>> previousSelections = new HashMap<String, List<Integer>>();

    public ElementListSelectionDialog(Shell parent, ILabelProvider labelProvider) {
        super(parent, labelProvider);
        this.labelProvider = labelProvider;
        this.setIgnoreCase(true);
    }

    public void setElements(Object ... elements) {
        this.elementList = null;
        this.addElements(elements);
    }

    public void addElements(Object ... elements) {
        if (this.elementList == null) {
            this.elementList = new ArrayList<Object>();
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            this.elementList.add(e);
            ++n2;
        }
    }

    public void setElements(Collection c) {
        this.elementList = null;
        this.addElements(c);
    }

    public void addElements(Collection c) {
        if (this.elementList == null) {
            this.elementList = new ArrayList<Object>();
        }
        for (Object e : c) {
            this.elementList.add(e);
        }
    }

    public void updateList() {
        if (this.fFilteredList != null && this.elementList != null) {
            Object[] objs = this.elementList.toArray(new Object[this.elementList.size()]);
            final boolean isEmpty = objs.length == 0;
            this.setListElements(objs);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ElementListSelectionDialog.this.handleListChange(isEmpty);
                }
            };
            Display d = this.getShell().getDisplay();
            if (Thread.currentThread() == d.getThread()) {
                r.run();
            } else {
                d.asyncExec(r);
            }
        }
    }

    protected void handleListChange(boolean isEmpty) {
        boolean wasEnabled = this.filterText.isEnabled();
        boolean enable = !isEmpty;
        this.messageLabel.setEnabled(enable);
        this.filterText.setEnabled(enable);
        this.fFilteredList.setEnabled(enable);
        if (!wasEnabled) {
            this.filterText.setFocus();
        }
        this.updateOkState();
    }

    public void sortElements() {
        if (this.elementList == null) {
            return;
        }
        Object[] objects = this.elementList.toArray(new Object[0]);
        Arrays.sort(objects, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String n1 = ElementListSelectionDialog.this.labelProvider.getText(o1).toLowerCase();
                String n2 = ElementListSelectionDialog.this.labelProvider.getText(o2).toLowerCase();
                return n1.compareTo(n2);
            }
        });
        this.elementList = new ArrayList<Object>(objects.length);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.elementList.add(o);
            ++n2;
        }
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = title;
    }

    public void setInitialSelection(Object selectedElement) {
        this.setInitialSelections(new Object[]{selectedElement});
    }

    protected Label createMessageArea(Composite composite) {
        this.messageLabel = super.createMessageArea(composite);
        return this.messageLabel;
    }

    protected Text createFilterText(Composite parent) {
        this.filterText = super.createFilterText(parent);
        return this.filterText;
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList flist = super.createFilteredList(parent);
        if (this.usePreviousSelectionSort) {
            ArrayList<Object> prioritizeList = new ArrayList<Object>();
            int[] previousSelections = ElementListSelectionDialog.getPreviousSelections(this.title);
            int i = 0;
            while (i < previousSelections.length) {
                int j = 0;
                while (j < this.elementList.size()) {
                    String name;
                    if (this.elementList.get(j).hashCode() == previousSelections[i] && (name = this.labelProvider.getText(this.elementList.get(j))) != null) {
                        prioritizeList.add(name);
                        if (prioritizeList.size() > 5) break;
                    }
                    ++j;
                }
                ++i;
            }
            flist.setComparator((Comparator)new PrioritizeComparator(prioritizeList, this.isCaseIgnored()));
        }
        return flist;
    }

    protected void createControls(Composite contents) {
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createFilteredList(contents);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createControls(contents);
        this.setListElements(this.elementList.toArray(new Object[this.elementList.size()]));
        this.setSelection(this.getInitialElementSelections().toArray());
        return contents;
    }

    protected void okPressed() {
        super.okPressed();
        Object[] objectArray = this.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ElementListSelectionDialog.addSelection(this.title, o);
            ++n2;
        }
    }

    protected static synchronized int[] getPreviousSelections(String key) {
        List<Integer> list = previousSelections.get(key);
        if (list == null) {
            return new int[0];
        }
        int[] result = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            result[i] = list.get(i);
            ++i;
        }
        return result;
    }

    protected static synchronized void addSelection(String key, Object o) {
        List<Integer> list = previousSelections.get(key);
        if (list == null) {
            list = new ArrayList<Integer>();
            previousSelections.put(key, list);
        }
        int hash = o.hashCode();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == hash) {
                list.remove(i);
            }
            ++i;
        }
        list.add(0, o.hashCode());
        if (list.size() > 128) {
            list.remove(list.size() - 1);
        }
    }

    public int[] getSelectionIndices() {
        return super.getSelectionIndices();
    }

    public boolean isUsePreviousSelectionSort() {
        return this.usePreviousSelectionSort;
    }

    public void setUsePreviousSelectionSort(boolean usePreviousSelectionSort) {
        this.usePreviousSelectionSort = usePreviousSelectionSort;
    }
}

