/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.simantics.ui.workbench.WorkbenchShutdownService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchShutdownServiceImpl
implements WorkbenchShutdownService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchShutdownServiceImpl.class);
    private static ServiceRegistration service = null;
    private final List<Runnable> hooks = new ArrayList<Runnable>();

    public static synchronized void initialize(BundleContext context) {
        if (service == null) {
            service = context.registerService(WorkbenchShutdownService.class.getName(), (Object)new WorkbenchShutdownServiceImpl(), new Hashtable());
        }
    }

    public static synchronized void close() {
        if (service != null) {
            service.unregister();
            service = null;
        }
    }

    @Override
    public synchronized void registerShutdownHook(Runnable hook) {
        this.hooks.add(hook);
    }

    @Override
    public synchronized void doShutdown() {
        Runnable[] rs = this.hooks.toArray(new Runnable[0]);
        this.hooks.clear();
        Runnable[] runnableArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable hook = runnableArray[n2];
            try {
                hook.run();
            }
            catch (Exception e) {
                this.handleException(hook, e);
            }
            catch (LinkageError e) {
                this.handleException(hook, e);
            }
            catch (AssertionError e) {
                this.handleException(hook, (Throwable)((Object)e));
            }
            ++n2;
        }
    }

    protected void handleException(Object source, Throwable t) {
        LOGGER.error(this.getClass().getSimpleName() + ": workbench shutdown hook " + String.valueOf(source) + " caused unexpected exception:", t);
    }
}

