/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.simantics.db.procedure.Listener;
import org.simantics.ui.internal.Activator;

public class TitleUpdater
implements Listener<String> {
    private final Display display;
    private final Consumer<String> callback;
    private final Supplier<Boolean> disposed;

    public TitleUpdater(Display display, Consumer<String> titleChangedCallback, Supplier<Boolean> disposed) {
        this.display = display;
        this.callback = titleChangedCallback;
        this.disposed = disposed;
    }

    public void execute(final String result) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TitleUpdater.this.isDisposed()) {
                    TitleUpdater.this.callback.accept(result);
                }
            }
        });
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public void exception(Throwable t) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.ui", "Title update failed.", t));
    }
}

