/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.GraphAccessViewPart;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public abstract class ResourceInputViewPart
extends GraphAccessViewPart {
    private static final String NO_NAME = "(no name)";
    private static final String MULTIPLE_NAMES = "(multiple names)";
    private ResourceInput mainInput;
    private Resource inputResource;
    private String inputName = "(no name)";

    public Resource getInputResource() {
        return this.inputResource;
    }

    public String getInputName() {
        return this.inputName;
    }

    private void initializeInput() {
        String secondaryId = this.getViewSite().getSecondaryId();
        if (secondaryId == null) {
            return;
        }
        this.mainInput = ResourceInput.unmarshall(secondaryId);
        try {
            this.inputResource = this.mainInput.toResource(this.getSession());
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeInput();
    }

    protected boolean inputExists(ReadGraph g) throws DatabaseException {
        if (this.inputResource == null) {
            return false;
        }
        return g.hasStatement(this.inputResource);
    }

    @Override
    protected void cleanup() {
        this.inputResource = null;
        super.cleanup();
    }

    public ResourceInput getMainInput() {
        return this.mainInput;
    }

    @Override
    protected String getTitleText() {
        return this.getInputName();
    }

    @Override
    protected String getTitleTooltip() {
        return this.getInputName();
    }

    @Override
    protected void update(ChangeEvent event) throws DatabaseException {
        ReadGraph g = event.getGraph();
        if (!this.inputExists(g)) {
            WorkbenchUtils.hideView((IWorkbenchWindow)this.getViewSite().getWorkbenchWindow(), (IViewPart)this);
            return;
        }
        this.updateModelCache(g);
        this.reload(g);
    }

    private void updateModelCache(ReadGraph graph) {
        try {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            this.inputName = (String)graph.getPossibleRelatedValue(this.inputResource, L0.HasName);
            if (this.inputName == null) {
                this.inputName = NO_NAME;
            }
        }
        catch (DatabaseException databaseException) {
            this.inputName = MULTIPLE_NAMES;
        }
    }
}

