/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;

public class ResourceInput {
    private static final String SUFFIX_SEPARATOR = "@";
    private static final String EMPTY_SUFFIX = "";
    private final String inputResourceId;
    private final String suffix;

    public ResourceInput(String randomAccessResourceId) {
        this.inputResourceId = randomAccessResourceId;
        this.suffix = EMPTY_SUFFIX;
    }

    public ResourceInput(String randomAccessResourceId, String uniqueSuffix) {
        this.inputResourceId = randomAccessResourceId;
        this.suffix = uniqueSuffix == null ? EMPTY_SUFFIX : uniqueSuffix;
    }

    public ResourceInput changeInput(String newRandomAccessResourceId) {
        if (this.suffix == EMPTY_SUFFIX) {
            return new ResourceInput(newRandomAccessResourceId);
        }
        return new ResourceInput(newRandomAccessResourceId, this.suffix);
    }

    public String getInputResourceId() {
        return this.inputResourceId;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.marshall();
    }

    public Resource toResource(Session session) throws DatabaseException {
        return (Resource)session.syncRequest(Queries.resource((String)this.inputResourceId));
    }

    public String marshall() {
        return String.format("%s@%s", this.inputResourceId, this.suffix);
    }

    public static ResourceInput unmarshall(String input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        String[] parts = input.split(SUFFIX_SEPARATOR);
        if (parts.length < 1) {
            throw new IllegalArgumentException("invalid input: " + input);
        }
        String id = parts[0];
        String suffix = EMPTY_SUFFIX;
        if (parts.length > 1) {
            suffix = input.substring(id.length() + 1);
        }
        return new ResourceInput(id, suffix);
    }

    public static Resource unmarshallToResource(String input, Session session) throws DatabaseException {
        ResourceInput in = ResourceInput.unmarshall(input);
        return in.toResource(session);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.inputResourceId == null ? 0 : this.inputResourceId.hashCode());
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceInput other = (ResourceInput)obj;
        if (this.inputResourceId == null ? other.inputResourceId != null : !this.inputResourceId.equals(other.inputResourceId)) {
            return false;
        }
        return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
    }
}

