/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.part.EditorPart;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.IResourceEditorPart;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.ToolTipRequest;

public abstract class ResourceEditorPart
extends EditorPart
implements IResourceEditorPart {
    protected boolean disposed = false;
    protected ResourceEditorSupport support;
    private DisposedSupplier previousTitleListener = null;

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.init(site, input, this.getInputValidator());
    }

    protected void createSupport(ParametrizedRead<IResourceEditorInput, Boolean> inputValidator) throws PartInitException {
        this.support = new ResourceEditorSupport(this, inputValidator);
    }

    protected void init(IEditorSite site, IEditorInput input, ParametrizedRead<IResourceEditorInput, Boolean> inputValidator) throws PartInitException {
        if (!(input instanceof IResourceEditorInput)) {
            throw new PartInitException("Invalid input: must be IResourceEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.createSupport(inputValidator);
        this.setPartName(this.getEditorInput().getName());
        Session session = Simantics.peekSession();
        if (session != null) {
            this.trackEditorTitle(site, this.getResourceInput(), session);
            this.addPropertyListener((source, propId) -> {
                if (258 == propId) {
                    this.trackEditorTitle(this.getEditorSite(), this.getResourceInput(), session);
                }
            });
        }
    }

    protected void trackEditorTitle(IEditorSite site, IResourceEditorInput input, Session session) {
        DisposedSupplier disposedCallback;
        if (this.previousTitleListener != null) {
            this.previousTitleListener.dispose();
        }
        this.previousTitleListener = disposedCallback = new DisposedSupplier();
        String id = site.getId();
        Display display = site.getShell().getDisplay();
        session.asyncRequest((Read)new TitleRequest(id, input), (Listener)new TitleUpdater(display, this::safeSetPartName, disposedCallback));
        session.asyncRequest((Read)new ToolTipRequest(id, input), (Listener)new TitleUpdater(display, this::safeSetTitleToolTip, disposedCallback));
    }

    protected void safeSetPartName(String partName) {
        if (!this.disposed && this.checkCompatibilityPartNotBeingDisposed()) {
            this.setPartName(partName);
        }
    }

    private boolean checkCompatibilityPartNotBeingDisposed() {
        PartSite partSite;
        Object object;
        IWorkbenchPartSite site = this.getSite();
        if (site instanceof PartSite && (object = (partSite = (PartSite)this.getSite()).getModel().getObject()) instanceof CompatibilityEditor) {
            CompatibilityEditor editor = (CompatibilityEditor)object;
            return !editor.isBeingDisposed();
        }
        return true;
    }

    protected void safeSetTitleToolTip(String toolTip) {
        if (!this.disposed) {
            this.setTitleToolTip(toolTip);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.support.dispose();
        super.dispose();
    }

    protected void activateValidation() {
        this.support.activateValidation();
    }

    public ISessionContext getSessionContext() {
        return this.support.getSessionContext();
    }

    public Session getSession() {
        return this.support.getSession();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public IResourceEditorInput getResourceInput() {
        return (IResourceEditorInput)this.getEditorInput();
    }

    public IStatusLineManager getStatusLineManager() {
        IActionBars bars = this.getEditorSite().getActionBars();
        IStatusLineManager mgr = bars.getStatusLineManager();
        return mgr;
    }

    public void setStatusMessage(String message) {
        this.getStatusLineManager().setMessage(message);
    }

    public void setStatusErrorMessage(String message) {
        this.getStatusLineManager().setErrorMessage(message);
    }

    protected Resource getInputResource() {
        return this.getResourceInput().getResource();
    }

    protected String getInputName() {
        return this.getEditorInput().getName();
    }

    protected String getTitleText() {
        return this.getInputName();
    }

    protected String getTitleTooltip() {
        return this.getInputName();
    }

    protected void updateTitle() {
        this.setPartName(this.getTitleText());
        this.setTitleToolTip(this.getTitleTooltip());
    }

    protected void asyncExec(Runnable run) {
        this.getSite().getShell().getDisplay().asyncExec(run);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Session.class) {
            return (T)this.getSession();
        }
        return (T)super.getAdapter(adapter);
    }

    private class DisposedSupplier
    implements Supplier<Boolean> {
        private boolean isDisposed = false;

        private DisposedSupplier() {
        }

        public void dispose() {
            this.isDisposed = true;
        }

        @Override
        public Boolean get() {
            if (!this.isDisposed && !ResourceEditorPart.this.disposed) {
                return false;
            }
            return true;
        }
    }
}

