/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.lang.ref.Reference;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.simantics.Simantics;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.ui.icons.ImageDescriptorProvider;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.ResourceEditorInputFactory2;
import org.simantics.ui.workbench.ResourceInputs;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.StringMemento;

public class ResourceEditorInput2
extends PlatformObject
implements IResourceEditorInput2,
IPersistableElement {
    private static final boolean DEBUG_EXISTS = false;
    private static final boolean DEBUG_UPDATE = false;
    private static final String NO_NAME = "(no name)";
    private final String editorID;
    protected String modelId;
    protected String rvi;
    private String resourceId;
    private transient Reference<Resource> model;
    private transient Reference<Resource> resource;
    private transient boolean exists;
    private transient String name;
    private transient String tooltip;
    private transient ImageDescriptor imageDesc;
    private final StringMemento persistentStore = new StringMemento();

    ResourceEditorInput2(String editorID, String resourceId, String modelId, String rvi) {
        if (editorID == null) {
            throw new IllegalArgumentException("null editor id");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("null resource id");
        }
        this.editorID = editorID;
        this.resourceId = resourceId;
        this.resource = null;
        this.modelId = modelId;
        this.model = null;
        this.rvi = rvi;
        this.setNonExistant();
    }

    public ResourceEditorInput2(String editorID, String resourceId, String modelId, RVI rvi) {
        if (editorID == null) {
            throw new IllegalArgumentException("null editor id");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("null resource id");
        }
        this.editorID = editorID;
        this.resourceId = resourceId;
        this.resource = null;
        this.modelId = modelId;
        this.model = null;
        this.rvi = rvi.toString();
        this.setNonExistant();
    }

    @Deprecated
    public ResourceEditorInput2(String editorID, Resource resource, Resource model, String rvi) {
        if (editorID == null) {
            throw new IllegalArgumentException("null editor id");
        }
        if (resource == null) {
            throw new IllegalArgumentException("null resource");
        }
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        this.editorID = editorID;
        this.resourceId = ResourceInputs.getRandomAccessId(resource);
        this.resource = ResourceInputs.makeReference(resource);
        this.modelId = ResourceInputs.getRandomAccessId(model);
        this.model = ResourceInputs.makeReference(model);
        this.rvi = rvi;
        this.setNonExistant();
    }

    public ResourceEditorInput2(String editorID, Resource resource, Resource model, RVI rvi) {
        if (editorID == null) {
            throw new IllegalArgumentException("null editor id");
        }
        if (resource == null) {
            throw new IllegalArgumentException("null resource");
        }
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        this.editorID = editorID;
        this.resourceId = ResourceInputs.getRandomAccessId(resource);
        this.resource = ResourceInputs.makeReference(resource);
        this.modelId = ResourceInputs.getRandomAccessId(model);
        this.model = ResourceInputs.makeReference(model);
        this.rvi = rvi != null ? rvi.toString() : null;
        this.setNonExistant();
    }

    @Override
    public void init(IAdaptable adapter) throws DatabaseException {
        Resource r = this.getResource();
        if (r != null) {
            this.updateCaches((AsyncRequestProcessor)this.getSession(), true);
        }
    }

    @Override
    public void dispose() {
        this.resource = null;
        this.model = null;
    }

    public Session getSession() {
        Session s = Simantics.getSession();
        if (((LifecycleSupport)s.getService(LifecycleSupport.class)).isClosed()) {
            throw new IllegalStateException("database session is closed");
        }
        return s;
    }

    public boolean exists() {
        return this.exists;
    }

    @Override
    public boolean exists(ReadGraph graph) throws DatabaseException {
        try {
            this.assertExists(graph);
            return true;
        }
        catch (MissingVariableException missingVariableException) {
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
        }
        catch (Nonexistant nonexistant) {}
        return false;
    }

    public Resource getResource0() throws DatabaseException {
        Resource r = this.tryGetResource();
        if (r != null) {
            return r;
        }
        Session s = ResourceInputs.peekSession();
        if (s == null) {
            return null;
        }
        r = ResourceInputs.resolveResource((RequestProcessor)s, this.resourceId);
        this.resource = ResourceInputs.makeReference(r);
        return r;
    }

    public Resource getModel0() throws DatabaseException {
        Resource r = this.tryGetModel();
        if (r != null) {
            return r;
        }
        Session s = ResourceInputs.peekSession();
        if (s == null) {
            return null;
        }
        r = ResourceInputs.resolveResource((RequestProcessor)s, this.modelId);
        this.model = ResourceInputs.makeReference(r);
        return r;
    }

    @Override
    public Resource getResource() {
        try {
            return this.getResource0();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    @Override
    @Deprecated
    public ResourceArray getResourceArray() {
        Resource r = this.getResource();
        return r == null ? ResourceArray.EMPTY : new ResourceArray(new Resource[]{r});
    }

    @Override
    public Resource getModel(ReadGraph graph) {
        try {
            return this.getModel0();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    @Override
    public String getRVI() {
        return this.rvi;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDesc;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public IPersistableElement getPersistable() {
        if (!this.isPersistable()) {
            return null;
        }
        return this;
    }

    protected boolean isPersistable() {
        Session session = Simantics.peekSession();
        if (session == null) {
            return false;
        }
        LifecycleSupport lc = (LifecycleSupport)session.peekService(LifecycleSupport.class);
        if (lc == null) {
            return false;
        }
        return !lc.isClosed();
    }

    public String getFactoryId() {
        return ResourceEditorInputFactory2.getFactoryId();
    }

    public void saveState(IMemento memento) {
        IMemento child = memento.createChild("resourceId");
        child.putTextData(this.resourceId);
        memento.putString("editorId", this.editorID);
        memento.putString("modelId", this.modelId);
        memento.putString("rvi", this.rvi);
        memento.putString("external", this.persistentStore.toString());
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.editorID.hashCode();
        result = 31 * result + Objects.hashCode(this.modelId);
        result = 31 * result + Objects.hashCode(this.resourceId);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceEditorInput2 other = (ResourceEditorInput2)obj;
        if (!this.editorID.equals(other.editorID)) {
            return false;
        }
        if (!Objects.equals(this.modelId, other.modelId)) {
            return false;
        }
        if (!Objects.equals(this.rvi, other.rvi)) {
            return false;
        }
        return Objects.equals(this.resourceId, other.resourceId);
    }

    private void updateCaches(AsyncRequestProcessor processor, boolean sync) throws DatabaseException {
        ReadRequest req = new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                ResourceEditorInput2.this.update(g);
            }
        };
        if (sync) {
            processor.syncRequest((Read)req);
        } else {
            processor.asyncRequest((Read)req);
        }
    }

    @Override
    public void update(ReadGraph g) throws DatabaseException {
        Resource r = this.getResource();
        if (r == null) {
            return;
        }
        try {
            this.name = (String)g.syncRequest((Read)new TitleRequest(this.editorID, this));
            if (this.name == null) {
                this.name = NO_NAME;
            }
            this.tooltip = (String)g.syncRequest((Read)new ToolTipRequest(this.editorID, this));
            if (this.tooltip == null) {
                this.tooltip = NO_NAME;
            }
            try {
                ImageDescriptorProvider idp = (ImageDescriptorProvider)g.adapt(r, ImageDescriptorProvider.class);
                this.imageDesc = (ImageDescriptor)idp.get();
            }
            catch (AdaptionException adaptionException) {
                this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
            }
            catch (ProvisionException e) {
                this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        catch (DatabaseException e) {
            this.setNonExistant();
        }
    }

    private void assertExists(ReadGraph g) throws DatabaseException {
        Resource r = this.getResource();
        if (r == null) {
            throw new Nonexistant();
        }
        this.exists = g.hasStatement(r);
        if (!this.exists) {
            throw new Nonexistant();
        }
        Resource model = this.getModel(g);
        if (model == null) {
            throw new Nonexistant();
        }
        this.exists = g.hasStatement(model);
        if (!this.exists) {
            throw new Nonexistant();
        }
        if (this.rvi != null && !this.rvi.isEmpty()) {
            Variable context = Variables.getPossibleConfigurationContext((ReadGraph)g, (Resource)model);
            if (context == null) {
                throw new Nonexistant();
            }
            RVI rvi_ = RVI.fromResourceFormat((RequestProcessor)g, (String)this.rvi);
            Variable variable = rvi_.resolvePossible(g, context);
            if (variable == null) {
                throw new Nonexistant();
            }
        }
        g.syncRequest((Read)new TitleRequest(this.editorID, this));
    }

    private void setNonExistant() {
        this.exists = false;
        this.name = NO_NAME;
        this.tooltip = NO_NAME;
        this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
    }

    public IMemento getPersistentStore() {
        return this.persistentStore;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.getName() + ", resource=" + String.valueOf(this.resource) + ", model=" + String.valueOf(this.model) + ", rvi=" + this.rvi + "]";
    }

    @Override
    public Variable getVariable() throws DatabaseException {
        return (Variable)this.getSession().syncRequest((Read)new Read<Variable>(){

            public Variable perform(ReadGraph graph) throws DatabaseException {
                return ResourceEditorInput2.this.getVariable(graph);
            }
        });
    }

    @Override
    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        Resource model = this.getModel(graph);
        String rvi = this.getRVI();
        if (rvi != null) {
            Variable configuration = Variables.getConfigurationContext((ReadGraph)graph, (Resource)model);
            RVI rrvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)rvi);
            return rrvi.resolve(graph, configuration);
        }
        return Variables.getVariable((ReadGraph)graph, (Resource)model);
    }

    private Resource tryGetResource() {
        Reference<Resource> ref = this.resource;
        return ref == null ? null : ref.get();
    }

    private Resource tryGetModel() {
        Reference<Resource> ref = this.model;
        return ref == null ? null : ref.get();
    }

    static class Nonexistant
    extends DatabaseException {
        private static final long serialVersionUID = -7964385375237203651L;

        Nonexistant() {
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

