/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.util.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.simantics.ui.workbench.IPerspectiveBarsExtension;
import org.simantics.ui.workbench.PerspectiveBarsManager;

public class PerspectiveBarsActivator
implements IPerspectiveListener4,
IWindowListener {
    private IWorkbenchWindow activeWindow;
    private Menu menu;

    public PerspectiveBarsActivator() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.activatePerspective(perspective.getId());
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.attachToWindow(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        this.detachFromWindow(window);
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    private void attachToWindow(IWorkbenchWindow window) {
        this.activeWindow = window;
        window.addPerspectiveListener((IPerspectiveListener)this);
        IPerspectiveDescriptor perspective = window.getActivePage().getPerspective();
        if (perspective != null) {
            this.activatePerspective(perspective.getId());
        }
    }

    private void detachFromWindow(IWorkbenchWindow window) {
        window.removePerspectiveListener((IPerspectiveListener)this);
    }

    private void activatePerspective(String perspectiveId) {
        List<IPerspectiveBarsExtension> exts = PerspectiveBarsManager.getInstance().getExtensions(perspectiveId);
        Boolean menuBar = null;
        Boolean coolBar = null;
        Boolean statusLine = null;
        Boolean perspectiveBar = null;
        Boolean fastViewBar = null;
        Boolean progressIndicator = null;
        for (IPerspectiveBarsExtension ext : exts) {
            if (menuBar == null) {
                menuBar = ext.getMenuBar();
            }
            if (coolBar == null) {
                coolBar = ext.getCoolBar();
            }
            if (statusLine == null) {
                statusLine = ext.getStatusLine();
            }
            if (perspectiveBar == null) {
                perspectiveBar = ext.getPerspectiveBar();
            }
            if (fastViewBar == null) {
                fastViewBar = ext.getFastViewBar();
            }
            if (progressIndicator != null) continue;
            progressIndicator = ext.getProgressIndicator();
        }
        if (this.activeWindow instanceof WorkbenchWindow) {
            WorkbenchWindow window = (WorkbenchWindow)this.activeWindow;
            if (menuBar == null || menuBar.booleanValue()) {
                m = window.getShell().getMenuBar();
                if (m == null && this.menu != null) {
                    window.getShell().setMenuBar(this.menu);
                }
            } else {
                m = window.getShell().getMenuBar();
                if (m != null) {
                    this.menu = m;
                    window.getShell().setMenuBar(null);
                }
            }
            if (coolBar == null || coolBar.booleanValue()) {
                window.setCoolBarVisible(true);
            } else {
                window.setCoolBarVisible(false);
            }
            if (statusLine == null || statusLine.booleanValue()) {
                window.setStatusLineVisible(true);
            } else {
                window.setStatusLineVisible(false);
            }
            if (perspectiveBar == null || perspectiveBar.booleanValue()) {
                window.setPerspectiveBarVisible(true);
            } else {
                window.setPerspectiveBarVisible(false);
            }
            if (progressIndicator == null || progressIndicator.booleanValue()) {
                r = window.getProgressRegion();
                if (r != null) {
                    r.getControl().setVisible(true);
                }
            } else {
                r = window.getProgressRegion();
                if (r != null) {
                    r.getControl().setVisible(false);
                }
            }
        }
    }
}

