/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.simantics.ui.workbench.MultiResourceEditorInput;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.StringMemento;

public class MultiResourceEditorInputFactory
implements IElementFactory {
    private static final String ID_FACTORY = "org.simantics.ui.workbench.multiResourceEditorInputFactory";
    public static final String TAG_RESOURCE_ID = "resourceId";
    public static final String TAG_EDITOR_ID = "editorId";
    public static final String TAG_MODEL_ID = "modelId";
    public static final String TAG_RVI = "rvi";
    public static final String TAG_EXTERNAL_MEMENTO_ID = "external";

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public IAdaptable createElement(IMemento memento) {
        IMemento[] mResourceIds = memento.getChildren(TAG_RESOURCE_ID);
        ArrayList<String> ids = new ArrayList<String>();
        IMemento[] iMementoArray = mResourceIds;
        int n = mResourceIds.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            ids.add(child.getTextData());
            ++n2;
        }
        IMemento[] mRvis = memento.getChildren(TAG_RVI);
        ArrayList<String> rvis = new ArrayList<String>();
        IMemento[] iMementoArray2 = mRvis;
        int n3 = mRvis.length;
        int n4 = 0;
        while (n4 < n3) {
            IMemento child = iMementoArray2[n4];
            rvis.add(child.getTextData());
            ++n4;
        }
        String editorId = memento.getString(TAG_EDITOR_ID);
        String modelId = memento.getString(TAG_MODEL_ID);
        try {
            MultiResourceEditorInput result = new MultiResourceEditorInput(editorId, modelId, ids, rvis);
            String externalMementoStr = memento.getString(TAG_EXTERNAL_MEMENTO_ID);
            if (externalMementoStr != null) {
                StringMemento sm = new StringMemento(externalMementoStr);
                sm.writeToMemento(result.getPersistentStore());
            }
            return result;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (IllegalArgumentException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }
}

