/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.simantics.Simantics;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.ui.icons.ImageDescriptorProvider;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.MultiResourceEditorInputFactory;
import org.simantics.ui.workbench.ResourceInputs;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.StringMemento;

public class MultiResourceEditorInput
extends PlatformObject
implements IEditorInput,
IResourceEditorInput,
IPersistableElement {
    private static final boolean DEBUG_EXISTS = false;
    private static final boolean DEBUG_UPDATE = false;
    private static final String NO_NAME = "(no name)";
    private String editorID;
    private Reference<Resource> model;
    private String modelId;
    private List<String> resourceIds;
    private List<Reference<Resource>> resources;
    private List<String> rvis;
    private transient String name;
    private transient boolean exists;
    private transient String tooltip;
    private transient ImageDescriptor imageDesc;
    private final StringMemento persistentStore = new StringMemento();

    public MultiResourceEditorInput(String editorID, Resource model, List<Resource> resources, List<RVI> rvis) {
        this.editorID = editorID;
        if (rvis != null && resources.size() != rvis.size()) {
            throw new IllegalArgumentException("There must be same amount of resources and RVIs");
        }
        this.modelId = ResourceInputs.getRandomAccessId(model);
        this.model = ResourceInputs.makeReference(model);
        this.resourceIds = new ArrayList<String>(resources.size());
        this.resources = new ArrayList<Reference<Resource>>(resources.size());
        for (Resource resource : resources) {
            this.resourceIds.add(ResourceInputs.getRandomAccessId(resource));
            this.resources.add(ResourceInputs.makeReference(resource));
        }
        if (rvis != null) {
            this.rvis = new ArrayList<String>(rvis.size());
            for (RVI rvi : rvis) {
                this.rvis.add(rvi.toString());
            }
        }
        this.setNonExistant();
    }

    public MultiResourceEditorInput(String editorID, String modelId, List<String> resourceIds, List<String> rvis) {
        this.editorID = editorID;
        if (rvis != null && resourceIds.size() != rvis.size()) {
            throw new IllegalArgumentException("There must be same amount of resources and RVIs");
        }
        this.modelId = modelId;
        this.model = null;
        this.resourceIds = new ArrayList<String>(resourceIds.size());
        this.resources = new ArrayList<Reference<Resource>>(resourceIds.size());
        for (String resourceId : resourceIds) {
            this.resourceIds.add(resourceId);
            this.resources.add(null);
        }
        this.rvis = rvis;
        this.setNonExistant();
    }

    @Override
    public void dispose() {
        this.model = null;
        this.resources = null;
    }

    @Override
    public void init(IAdaptable adapter) throws DatabaseException {
        Resource r = this.getResource();
        if (r != null) {
            this.updateCaches((AsyncRequestProcessor)this.getSession(), true);
        }
    }

    public Session getSession() {
        Session s = Simantics.getSession();
        if (((LifecycleSupport)s.getService(LifecycleSupport.class)).isClosed()) {
            throw new IllegalStateException("database session is closed");
        }
        return s;
    }

    public boolean exists() {
        return this.exists;
    }

    @Override
    public boolean exists(ReadGraph graph) throws DatabaseException {
        try {
            this.assertExists(graph);
            return true;
        }
        catch (MissingVariableException missingVariableException) {
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
        }
        catch (Nonexistant nonexistant) {}
        return false;
    }

    public Resource getResource(int index) throws DatabaseException {
        Resource r = this.tryGetResource(index);
        if (r != null) {
            return r;
        }
        Session s = ResourceInputs.peekSession();
        if (s == null) {
            return null;
        }
        r = ResourceInputs.resolveResource((RequestProcessor)s, this.resourceIds.get(index));
        while (this.resources.size() <= index) {
            this.resources.add(null);
        }
        this.resources.set(index, ResourceInputs.makeReference(r));
        return r;
    }

    public Resource getModel0() throws DatabaseException {
        Resource r = this.tryGetModel();
        if (r != null) {
            return r;
        }
        Session s = ResourceInputs.peekSession();
        if (s == null) {
            return null;
        }
        r = ResourceInputs.resolveResource((RequestProcessor)s, this.modelId);
        this.model = ResourceInputs.makeReference(r);
        return r;
    }

    @Override
    public Resource getResource() {
        try {
            return this.getResource(0);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    @Override
    public ResourceArray getResourceArray() {
        ArrayList<Resource> _resources = new ArrayList<Resource>(this.resourceIds.size());
        try {
            int i = 0;
            while (i < this.resourceIds.size()) {
                Resource r = this.getResource(i);
                if (r != null) {
                    _resources.add(r);
                }
                ++i;
            }
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return ResourceArray.EMPTY;
        }
        ResourceArray ra = new ResourceArray(_resources);
        return ra;
    }

    public Resource getModel(ReadGraph graph) {
        try {
            return this.getModel0();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public String getRVI(int index) {
        return this.rvis.get(index);
    }

    public List<String> getRvis() {
        return this.rvis;
    }

    public int size() {
        return this.resourceIds.size();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDesc;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public IPersistableElement getPersistable() {
        if (!this.isPersistable()) {
            return null;
        }
        return this;
    }

    protected boolean isPersistable() {
        Session session = Simantics.peekSession();
        if (session == null) {
            return false;
        }
        LifecycleSupport lc = (LifecycleSupport)session.peekService(LifecycleSupport.class);
        if (lc == null) {
            return false;
        }
        return !lc.isClosed();
    }

    public String getFactoryId() {
        return MultiResourceEditorInputFactory.getFactoryId();
    }

    public void saveState(IMemento memento) {
        IMemento child;
        for (String resourceId : this.resourceIds) {
            child = memento.createChild("resourceId");
            child.putTextData(resourceId);
        }
        for (String rvi : this.rvis) {
            child = memento.createChild("rvi");
            child.putTextData(rvi);
        }
        memento.putString("editorId", this.editorID);
        memento.putString("modelId", this.modelId);
        memento.putString("external", this.persistentStore.toString());
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.editorID.hashCode();
        result = 31 * result + Objects.hashCode(this.modelId);
        for (String resourceId : this.resourceIds) {
            result = 31 * result + Objects.hashCode(resourceId);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiResourceEditorInput other = (MultiResourceEditorInput)obj;
        if (!this.editorID.equals(other.editorID)) {
            return false;
        }
        if (!Objects.equals(this.modelId, other.modelId)) {
            return false;
        }
        if (this.rvis.size() != other.rvis.size()) {
            return false;
        }
        int i = 0;
        while (i < this.rvis.size()) {
            if (!Objects.equals(this.rvis.get(i), other.rvis.get(i))) {
                return false;
            }
            ++i;
        }
        if (this.resourceIds.size() != other.resourceIds.size()) {
            return false;
        }
        i = 0;
        while (i < this.resourceIds.size()) {
            if (!Objects.equals(this.resourceIds.get(i), other.resourceIds.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void updateCaches(AsyncRequestProcessor processor, boolean sync) throws DatabaseException {
        ReadRequest req = new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                MultiResourceEditorInput.this.update(g);
            }
        };
        if (sync) {
            processor.syncRequest((Read)req);
        } else {
            processor.asyncRequest((Read)req);
        }
    }

    @Override
    public void update(ReadGraph g) throws DatabaseException {
        Resource r = this.getResource();
        if (r == null) {
            return;
        }
        try {
            this.name = (String)g.syncRequest((Read)new TitleRequest(this.editorID, this));
            if (this.name == null) {
                this.name = NO_NAME;
            }
            this.tooltip = (String)g.syncRequest((Read)new ToolTipRequest(this.editorID, this));
            if (this.tooltip == null) {
                this.tooltip = NO_NAME;
            }
            try {
                ImageDescriptorProvider idp = (ImageDescriptorProvider)g.adapt(r, ImageDescriptorProvider.class);
                this.imageDesc = (ImageDescriptor)idp.get();
            }
            catch (AdaptionException adaptionException) {
                this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
            }
            catch (ProvisionException e) {
                this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        catch (DatabaseException e) {
            this.setNonExistant();
        }
    }

    private void assertExists(ReadGraph g) throws DatabaseException {
        Resource r = this.getResource();
        if (r == null) {
            throw new Nonexistant();
        }
        this.exists = g.hasStatement(r);
        if (!this.exists) {
            throw new Nonexistant();
        }
        Resource model = this.getModel(g);
        if (model == null) {
            throw new Nonexistant();
        }
        this.exists = g.hasStatement(model);
        if (!this.exists) {
            throw new Nonexistant();
        }
        for (String rvi : this.rvis) {
            if (rvi == null || rvi.isEmpty()) continue;
            Variable context = Variables.getPossibleConfigurationContext((ReadGraph)g, (Resource)model);
            if (context == null) {
                throw new Nonexistant();
            }
            RVI rvi_ = RVI.fromResourceFormat((RequestProcessor)g, (String)rvi);
            Variable variable = rvi_.resolvePossible(g, context);
            if (variable != null) continue;
            throw new Nonexistant();
        }
        g.syncRequest((Read)new TitleRequest(this.editorID, this));
    }

    private void setNonExistant() {
        this.exists = false;
        this.name = NO_NAME;
        this.tooltip = NO_NAME;
        this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
    }

    public IMemento getPersistentStore() {
        return this.persistentStore;
    }

    public Variable getVariable(final int index) throws DatabaseException {
        return (Variable)this.getSession().syncRequest((Read)new Read<Variable>(){

            public Variable perform(ReadGraph graph) throws DatabaseException {
                return MultiResourceEditorInput.this.getVariable(graph, index);
            }
        });
    }

    public Variable getVariable(ReadGraph graph, int index) throws DatabaseException {
        Resource model = this.getModel(graph);
        String rvi = this.getRVI(index);
        if (rvi != null) {
            Variable configuration = Variables.getConfigurationContext((ReadGraph)graph, (Resource)model);
            RVI rrvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)rvi);
            return rrvi.resolve(graph, configuration);
        }
        return Variables.getVariable((ReadGraph)graph, (Resource)model);
    }

    private Resource tryGetResource(int index) {
        Reference<Resource> ref = this.resources.get(index);
        return ref == null ? null : ref.get();
    }

    private Resource tryGetModel() {
        Reference<Resource> ref = this.model;
        return ref == null ? null : ref.get();
    }

    static class Nonexistant
    extends DatabaseException {
        private static final long serialVersionUID = 9062837207032093570L;

        Nonexistant() {
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

