/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.toolbar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;

public class ToolbarScaleUtil {
    private boolean initScale = false;
    private int scaledHeight = -1;
    private Font scaledFont;
    private Map<Control, Font> originalFonts = new HashMap<Control, Font>();

    public void initScale(Composite parent) {
        FontData[] data;
        Font font;
        if (this.initScale) {
            return;
        }
        ToolBar toolBar = this.getToolBar(parent);
        int totalHeight = 22;
        int actHeight = 16;
        int dpi = Display.getCurrent().getDPI().x;
        double scale = (double)dpi / 96.0;
        while (scale >= 1.99) {
            scale -= 1.0;
        }
        if (Math.abs(1.0 - scale) < 0.1) {
            return;
        }
        this.scaledHeight = (int)(Math.ceil((double)actHeight / scale) + 0.5);
        this.scaledHeight += totalHeight - actHeight;
        if (toolBar != null && (font = toolBar.getFont()) != null && scale > 1.0 && (data = font.getFontData()).length == 1) {
            FontData newData = new FontData(data[0].getName(), data[0].getHeight(), data[0].getStyle());
            newData.height = (float)((double)newData.height / scale);
            this.scaledFont = new Font((Device)Display.getCurrent(), newData);
        }
        this.initScale = true;
    }

    public boolean isInitScale() {
        return this.initScale;
    }

    public int getScaledHeight() {
        return this.scaledHeight;
    }

    public Font getScaledFont() {
        return this.scaledFont;
    }

    private ToolBar getToolBar(Composite parent) {
        Composite c = parent;
        while (c != null) {
            if (c instanceof ToolBar) {
                return (ToolBar)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public void scale(Control control) {
        this.scale(control, false);
    }

    public void scale(Control control, boolean restoreOnDispose) {
        if (this.scaledFont == null) {
            return;
        }
        Font currentFont = control.getFont();
        if (currentFont == this.scaledFont) {
            return;
        }
        if (restoreOnDispose && currentFont != null) {
            this.originalFonts.put(control, currentFont);
        }
        control.setFont(this.scaledFont);
    }

    public void scale(ToolBar toolbar) {
        if (this.scaledFont == null) {
            return;
        }
        if (toolbar.getFont() == this.scaledFont) {
            return;
        }
        this.originalFonts.put((Control)toolbar, toolbar.getFont());
        toolbar.setFont(this.scaledFont);
    }

    public void dispose() {
        for (Map.Entry<Control, Font> e : this.originalFonts.entrySet()) {
            if (e.getKey().isDisposed()) continue;
            e.getKey().setFont(e.getValue());
        }
        this.originalFonts.clear();
        if (this.scaledFont != null) {
            this.scaledFont.dispose();
            this.scaledFont = null;
        }
    }
}

