/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.toolbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;

public class ToolBarCommandRegistry
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.ui";
    private static final String EP_NAME = "toolbarCommand";
    private ExtensionTracker tracker;
    private List<ToolbarCommandExtension> extensions = new ArrayList<ToolbarCommandExtension>();
    private static ToolBarCommandRegistry INSTANCE;

    public static synchronized ToolBarCommandRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ToolBarCommandRegistry();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    public ToolBarCommandRegistry() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(ep.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)ep);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions.clear();
    }

    public synchronized List<ToolbarCommandExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    private synchronized void loadExtensions(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String commandId = el.getAttribute("commandId");
            ToolbarCommandExtension ext = new ToolbarCommandExtension(commandId);
            ext.toolbarId = el.getAttribute("toolbarId");
            ext.image = el.getAttribute("image");
            ext.name = el.getAttribute("name");
            ext.type = el.getAttribute("type");
            ext.value = el.getAttribute("value");
            ext.contributorId = el.getContributor().getName();
            IConfigurationElement[] iConfigurationElementArray2 = el.getChildren("parameter");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement param = iConfigurationElementArray2[n4];
                Parameter parameter = new Parameter();
                parameter.name = param.getAttribute("name");
                parameter.value = param.getAttribute("value");
                ext.parameters.add(parameter);
                ++n4;
            }
            this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
            this.extensions.add(ext);
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public synchronized void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ToolbarCommandExtension ext = (ToolbarCommandExtension)o;
            this.tracker.unregisterObject(extension, (Object)ext);
            this.extensions.remove(ext);
            ++n2;
        }
    }

    public synchronized List<ToolbarCommandExtension> getExtensions(String toolbarId) {
        ArrayList<ToolbarCommandExtension> list = new ArrayList<ToolbarCommandExtension>();
        for (ToolbarCommandExtension ext : this.extensions) {
            if (!ext.toolbarId.equals(toolbarId)) continue;
            list.add(ext);
        }
        return list;
    }

    public class Parameter {
        public String name;
        public String value;
    }

    public class ToolbarCommandExtension {
        public String commandId;
        public String toolbarId;
        public String name;
        public String type;
        public String value;
        public String image;
        public String contributorId;
        public List<Parameter> parameters = new ArrayList<Parameter>();

        public ToolbarCommandExtension(String commandId) {
            this.commandId = commandId;
        }

        public String toString() {
            return "ToolbarCommandExtension, commandId= " + this.commandId + " toolbarId= " + this.toolbarId + " type= " + this.type + " value= " + this.value + " contributor= " + this.contributorId;
        }
    }
}

