/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.selection;

import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ResourceVariable;
import org.simantics.db.request.ReadInterface;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;

public class ResourceWorkbenchSelectionElement
implements WorkbenchSelectionElement {
    private final Resource resource;

    public ResourceWorkbenchSelectionElement(Resource resource) {
        this.resource = resource;
    }

    @Override
    public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
        if (contentType instanceof AnyResource) {
            return (T)this.resource;
        }
        if (contentType instanceof AnyVariable) {
            AnyVariable type = (AnyVariable)contentType;
            try {
                return (T)type.processor.sync((ReadInterface)new ResourceVariable(this.resource));
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }
        return null;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ResourceWorkbenchSelectionElement)) {
            return false;
        }
        ResourceWorkbenchSelectionElement vwse = (ResourceWorkbenchSelectionElement)object;
        return this.resource.equals(vwse.resource);
    }
}

