/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.dialogs;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.simantics.ui.internal.Activator;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.action.IPriorityAction;

public class ActionChooserDialog
extends Dialog {
    private static final String DIALOG = "ActionChooserDialog";
    private final IAction[] actions;
    private final String title;
    private final String description;
    private IAction chosenAction;
    private TableViewer viewer;
    private IDialogSettings dialogBoundsSettings;
    private ResourceManager resourceManager;
    private final ViewerSorter sorter = new ViewerSorter(){

        public int category(Object element) {
            if (element instanceof IPriorityAction) {
                IPriorityAction action = (IPriorityAction)element;
                return -action.getPriority();
            }
            return Integer.MAX_VALUE;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IPriorityAction a1 = (IPriorityAction)e1;
            IPriorityAction a2 = (IPriorityAction)e2;
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)a1.getText(), (Object)a2.getText());
        }
    };

    public ActionChooserDialog(Shell parent, IPriorityAction[] actions, String title, String description) {
        super(parent);
        this.actions = actions;
        this.title = title;
        this.description = description;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(DIALOG);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected void configureShell(Shell newShell) {
        if (this.title != null) {
            newShell.setText(this.title);
        } else {
            newShell.setText("Choose Action");
        }
        super.configureShell(newShell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Point getInitialSize() {
        Point result;
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
            return new Point(300, 300);
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        composite.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ActionChooserDialog.this.resourceManager.dispose();
                ActionChooserDialog.this.resourceManager = null;
            }
        });
        if (this.description != null) {
            Label label = new Label(composite, 0);
            label.setText(this.description);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.viewer = new TableViewer(composite, 2820);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider());
        this.viewer.setSorter(this.sorter);
        this.viewer.setInput((Object)this.actions);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ActionChooserDialog.this.okPressed();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActionChooserDialog.this.selectionChanged(event.getSelection());
            }
        });
        if (this.actions.length > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.actions[0]), true);
        }
        ActionChooserDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void selectionChanged(ISelection s) {
        Button ok = this.getButton(0);
        IStructuredSelection iss = (IStructuredSelection)s;
        if (iss == null || iss.isEmpty()) {
            if (ok != null) {
                ok.setEnabled(false);
            }
            return;
        }
        if (ok != null) {
            ok.setEnabled(true);
        }
    }

    protected void okPressed() {
        this.chosenAction = (IAction)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        super.okPressed();
    }

    public IAction getChosenAction() {
        return this.chosenAction;
    }

    class ActionLabelProvider
    extends LabelProvider {
        ActionLabelProvider() {
        }

        public Image getImage(Object element) {
            IAction a = (IAction)element;
            ImageDescriptor desc = a.getImageDescriptor();
            if (desc == null) {
                return null;
            }
            return ActionChooserDialog.this.resourceManager.createImage(desc);
        }

        public String getText(Object element) {
            IPriorityAction a = (IPriorityAction)element;
            return a.getText() + " (" + a.getPriority() + ")";
        }
    }
}

