package org.simantics.ui.workbench.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.simantics.db.exception.DatabaseException;

abstract public class AbstractDatabaseHandler extends AbstractHandler {

	abstract public Object checkedExecute(ExecutionEvent event) throws ExecutionException, DatabaseException;
	
    @Override
    final public Object execute(ExecutionEvent event) throws ExecutionException {
    	try {
			return checkedExecute(event);
		} catch (DatabaseException e) {
			throw new ExecutionException("The handler caught an unhandled exception, ", e);
		}
    }	
	
}
