/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.editor.input;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorInput2;

/**
 * An editor input matching strategy that does not take into account the name in
 * the editor input. This is because in {@link ResourceEditorInput} and
 * {@link ResourceEditorInput2} the name is not important, only
 * <code>equals</code> is.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see IResourceEditorInput
 * @see IResourceEditorInput2
 * @see ResourceEditorInput
 * @see ResourceEditorInput2
 */
public class ResourceEditorInputMatchingStrategy implements IEditorMatchingStrategy {

    @Override
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        if (!(input instanceof IResourceEditorInput))
            return false;

        try {
            IEditorInput editorInput = editorRef.getEditorInput();
            return input.equals(editorInput);
        } catch (PartInitException e) {
            return false;
        }
    }

}
