/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.editor;

/**
 * An interface that needs to be implemented by {@link EditorAdapter}s
 * to give {@link EditorRegistry} the capability of assigning
 * extension-defined properties to the contributed editor adapters.
 * 
 * <p>
 * For example, {@link AbstractResourceEditorAdapter} implements this.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see AbstractResourceEditorAdapter
 */
public interface Prioritized {

    void setPriority(int priority);

}
