/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;


public class EditorAdapterDescriptorImpl implements EditorAdapterDescriptor {

    private final String                id;

    private final String                groupId;

    private final EditorAdapter adapter;

    /**
     * Null if there is no context limitation
     */
    private final String[]              inContexts;

    public EditorAdapterDescriptorImpl(String id, String groupId, EditorAdapter adapter, String[] inContexts) {
        this.id = id;
        if (groupId != null && groupId.isEmpty())
            groupId = null;
        this.groupId = groupId;
        this.adapter = adapter;
        if (inContexts != null && inContexts.length == 0)
            inContexts = null;
        this.inContexts = inContexts;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getGroupId() {
        return groupId;
    }

    @Override
    public EditorAdapter getAdapter() {
        return adapter;
    }

    @Override
    public Collection<String> getInContexts() {
        if (inContexts == null)
            return Collections.emptyList();
        return Arrays.asList(inContexts);
    }

    @Override
    public boolean isActive(Collection<?> activeContextIds) {
        // null indicates perpetually active
        if (inContexts == null)
            return true;

        for (Object o : inContexts)
            if (activeContextIds.contains(o))
                return true;
        return false;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EditorAdapterDescriptorImpl.class.getSimpleName()).append(" id=").append(id).append(" gId=").append(groupId);
        return sb.toString();
    }

}
