/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.editor;

import java.util.Collection;

public interface EditorAdapterDescriptor {

    /**
     * @return the id of this editor adapter
     */
    String getId();

    /**
     * @return <code>null</code> if no group id is defined
     */
    String getGroupId();

    /**
     * @return the adapter itself
     */
    EditorAdapter getAdapter();

    /**
     * @return
     */
    Collection<String> getInContexts();

    /**
     * @param activeContextIds
     * @return <code>true</code> if this 
     */
    boolean isActive(Collection<?> activeContextIds);

}