/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.action;

import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Tuukka Lehtonen
 */
public interface IWorkbenchActionHints {

    /**
     * A hint for holding the currently active perspective id for use in other
     * threads besides the SWT UI thread.
     */
    Key KEY_CURRENTPERSPECTIVE = new KeyOf(String.class);

    /**
     * A generic hint for stating whether to remember the result of a user
     * action or not.
     */
    Key KEY_REMEMBER           = new KeyOf(Boolean.class);

    /**
     * A generic hint for stating whether to always ask for input from the user
     * regardless of whether remembered setting could be used.
     */
    Key KEY_ALWAYS_ASK         = new KeyOf(Boolean.class);

    /**
     * A generic hint defining the source widget of an action.
     */
    Key KEY_WIDGET             = new KeyOf(Object.class);

}
