/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class WorkbenchResources {

    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.simantics.ui.workbench.messages"); //$NON-NLS-1$

    /**
     * Returns the resource object with the given key in the Workbench resource
     * bundle. If there isn't any value under the given key, the key is
     * returned.
     * 
     * @param key the resource name
     * @return the string
     */
    public static final String getString(String key) {
        try {
            return bundle.getString(key);
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Returns the formatted message for the given key in the Workbench resource
     * bundle.
     * 
     * @param key the resource name
     * @param args the message arguments
     * @return the string
     */
    public static String format(String key, Object[] args) {
        return MessageFormat.format(getString(key), args);
    }

}
