/*******************************************************************************
 * Copyright (c) 2014 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * A simple request that takes an IResourceEditorInput as input and calculates
 * the following editor title from it:
 * <code>input-name (input-parent-name)</code>.
 * 
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen
 * @see TitleRequest
 */
public class TitleWithParentNameRequest extends UnaryRead<IResourceEditorInput, String> {

    public TitleWithParentNameRequest(IResourceEditorInput input) {
        super(input);
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        Resource r = parameter.getResource();
        Resource parent = graph.getPossibleObject(r, L0.PartOf);
        String name = safeName(graph, r, "No name", L0);
        String parentName = safeName(graph, parent, "No parent", L0);
        return name + " (" + parentName + ")";
    }

    protected String safeName(ReadGraph graph, Resource r, String noNameValue, Layer0 L0) throws DatabaseException {
        if (r != null) {
            String name = graph.getPossibleRelatedValue(r, L0.HasName, Bindings.STRING);
            if (name != null) {
                return name;
            }
        }
        return noNameValue;
    }
    
}
