/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import java.util.function.Consumer;
import java.util.function.Supplier;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.simantics.db.procedure.Listener;
import org.simantics.ui.internal.Activator;

/**
 * @author Tuukka Lehtonen
 */
public class TitleUpdater implements Listener<String> {

    private final Display           display;
    private final Consumer<String>  callback;
    private final Supplier<Boolean> disposed;

    public TitleUpdater(Display display, Consumer<String> titleChangedCallback, Supplier<Boolean> disposed) {
        this.display = display;
        this.callback = titleChangedCallback;
        this.disposed = disposed;
    }

    @Override
    public void execute(final String result) {
        display.asyncExec(new Runnable() {
            @Override
            public void run() {
                if (!isDisposed())
                    callback.accept(result);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return disposed.get();
    }

    @Override
    public void exception(Throwable t) {
        Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Title update failed.", t));
    }

}
