/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;


/**
 * This class acts as a base class for Eclipse forms-based form-editors in a
 * using the ProCore semantic triple data model.
 * 
 * Extend SinglePageTypeEditor or MultiPageFormView to create your own editor,
 * not this one.
 * 
 * @author Antti Villberg
 * @author Tuukka Lehtonen
 */
public abstract class ResourceFormViewPart extends ResourceInputViewPart {

    protected FormToolkit toolkit;

    //----------------------------------------------------------------------
    // Getters
    
    public FormToolkit getToolkit() {
        return toolkit;
    }
    
    
    //----------------------------------------------------------------------
    // Event utilities

    public void reflow(boolean flushCache) {
        //System.out.println("FormTypeEditorBase.reflow(" + flushCache + ")");
        getActiveForm().reflow(flushCache);
    }
    
    
    //----------------------------------------------------------------------
    // Event handlers & initialisation

    @Override
    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createPartControl(parent);
    }

    @Override
    public void dispose() {
        if (toolkit != null) {
            toolkit.dispose();
        }
        super.dispose();
    }
    
    @Override
    public void setFocus() {
        //System.out.println("FormTypeEditorBase.setFocus(): Input = " + getInput());
        ScrolledForm form = getActiveForm();
        if (form != null) {
            form.setFocus();
        }
    }

    
    //----------------------------------------------------------------------
    // Implement these yourself:
    
    public abstract ScrolledForm getActiveForm();

    protected abstract String getFormText();
    
}
