package org.simantics.ui.workbench;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.simantics.ui.workbench.ResourceEditorInputFactory;
import org.simantics.ui.workbench.ResourceEditorInputFactory2;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.StringMemento;

public class MultiResourceEditorInputFactory implements IElementFactory {
    
    private static final String ID_FACTORY = "org.simantics.ui.workbench.multiResourceEditorInputFactory"; //$NON-NLS-1$
    
    public static final String TAG_RESOURCE_ID = ResourceEditorInputFactory.TAG_RESOURCE_ID; //$NON-NLS-1$
    public static final String TAG_EDITOR_ID = ResourceEditorInputFactory.TAG_EDITOR_ID; //$NON-NLS-1$
    public static final String TAG_MODEL_ID = ResourceEditorInputFactory2.TAG_MODEL_ID; //$NON-NLS-1$
    public static final String TAG_RVI  = ResourceEditorInputFactory2.TAG_RVI; //$NON-NLS-1$
    public static final String TAG_EXTERNAL_MEMENTO_ID = ResourceEditorInputFactory2.TAG_EXTERNAL_MEMENTO_ID; //$NON-NLS-1$
    
    
    
    public static String getFactoryId() {
        return ID_FACTORY;
    }
    
    /* (non-Javadoc)
     * Method declared on IElementFactory.
     */
    @Override
    public IAdaptable createElement(IMemento memento) {
        // Get the resource id array.
        IMemento[] mResourceIds = memento.getChildren(TAG_RESOURCE_ID);
        
        List<String> ids = new ArrayList<String>();
        for (IMemento child : mResourceIds)
            ids.add(child.getTextData());

        IMemento[] mRvis = memento.getChildren(TAG_RVI);
        List<String> rvis = new ArrayList<String>();
        for (IMemento child : mRvis)
            rvis.add(child.getTextData());
        
        String editorId = memento.getString(TAG_EDITOR_ID);
        String modelId = memento.getString(TAG_MODEL_ID);

        try {
            MultiResourceEditorInput result = new MultiResourceEditorInput(editorId, modelId, ids, rvis);

            // Read external persistent memento
            String externalMementoStr = memento.getString(TAG_EXTERNAL_MEMENTO_ID);
            if (externalMementoStr != null) {
                StringMemento sm = new StringMemento(externalMementoStr);
                sm.writeToMemento(result.getPersistentStore());
            }
            return result;
        } catch (NumberFormatException e) {
            return null;
        } catch (IllegalArgumentException e) {
            ErrorLogger.defaultLogError(e);
            return null;
        }
    }
}
