/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import java.util.function.Consumer;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.part.IPage;

/**
 * @author Tuukka Lehtonen
 * @see PropertyPage
 * @see AbstractPropertyPage
 */
public interface IPropertyPage extends IPage, ISelectionListener {

    /**
     * @return current selection or <code>null</code> if no selection is
     *         available
     */
    ISelection getSelection();

    /**
     * @param forSelection the new selection for calculating the new part name
     * @param updateCallback a callback that <em>can be</em> invoked by
     *        getPartName if it wishes to change the part name. If the page does
     *        not wish to change the part name, it does not have to invoke the
     *        updateCallback. A <code>null</code> value indicates that the part
     *        name should be returned to its default value.
     */
    void updatePartName(ISelection forSelection, Consumer<String> updateCallback);

}
