/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

public interface IPerspectiveBarsExtension {

    String getPerspectiveId();

    Boolean getMenuBar();
    Boolean getCoolBar();
    Boolean getStatusLine();
    Boolean getPerspectiveBar();
    Boolean getFastViewBar();
    Boolean getProgressIndicator();

    class Stub implements IPerspectiveBarsExtension {
        String   perspectiveId;
        Boolean menuBar;
        Boolean coolBar;
        Boolean statusLine;
        Boolean perspectiveBar;
        Boolean fastViewBar;
        Boolean progressIndicator;

        Stub(String perspectiveId, Boolean menuBar, Boolean coolBar, Boolean statusLine, Boolean perspectiveBar, Boolean fastViewBar, Boolean progressIndicator) {
            this.perspectiveId = perspectiveId;
            this.menuBar = menuBar;
            this.coolBar = coolBar;
            this.statusLine = statusLine;
            this.perspectiveBar = perspectiveBar;
            this.fastViewBar = fastViewBar;
            this.progressIndicator = progressIndicator;
        }

        @Override
        public String getPerspectiveId() {
            return perspectiveId;
        }
        
        @Override
        public Boolean getCoolBar() {
        	return coolBar;
        }
        
        @Override
        public Boolean getFastViewBar() {
        	return fastViewBar;
        }
        
        @Override
        public Boolean getMenuBar() {
        	return menuBar;
        }
        
        @Override
        public Boolean getPerspectiveBar() {
        	return perspectiveBar;
        }
        
        @Override
        public Boolean getProgressIndicator() {
        	return progressIndicator;
        }
        
        @Override
        public Boolean getStatusLine() {
        	return statusLine;
        }
    }
}
