/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.project.IProject;

/**
 * An IProject service for naming editors while working on a project.
 * 
 * @author Tuukka Lehtonen
 */
public final class EditorNaming {

    /**
     * @param graph
     * @param resource
     * @return
     * @throws DatabaseException
     */
    public static IEditorNamingService getNamingService(ReadGraph graph, Resource resource) throws DatabaseException {
        IEditorNamingService ems = graph.getPossibleAdapter(resource, IEditorNamingService.class);
        if (ems == null) {
            Resource model = graph.syncRequest(new PossibleIndexRoot(resource));
            if (model != null) {
                ems = graph.getPossibleAdapter(model, IEditorNamingService.class);
            }
        }

        // Last resort.
        if (ems == null) {
            IProject p = Simantics.peekProject();
            ems = p.getHint(IEditorNamingService.KEY_EDITOR_NAMING_SERVICE);
        }

        return ems;
    }

    /**
     * @param graph
     * @param variable
     * @return
     * @throws DatabaseException
     */
    public static IEditorNamingService getNamingService(ReadGraph graph, Variable variable) throws DatabaseException {
        IEditorNamingService ems = null;

        Resource r = variable.getPossibleRepresents(graph);
        if (r != null)
            ems = graph.getPossibleAdapter(r, IEditorNamingService.class);

        if (ems == null) {
            try {
                Resource model = Variables.getModel(graph, variable);
                ems = graph.getPossibleAdapter(model, IEditorNamingService.class);
            } catch (DatabaseException e) {
                // Ignore missing model, in this case the variable is lost anyway.
            }
        }

        // Last resort.
        if (ems == null) {
            IProject p = Simantics.peekProject();
            if (p != null) {
                ems = p.getHint(IEditorNamingService.KEY_EDITOR_NAMING_SERVICE);
            }
        }

        return ems;
    }

}
