/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

/**
 * @author Tuukka Lehtonen
 */
public final class ContextUtil {

    /**
     * Associate a workbench context specified by id with the focus state of the specified control.
     * 
     * @param site any workbench site
     * @param control the control whose focus to track for context activation
     * @param contextId the ID of the context to use
     */
    public static void associateContext(final IWorkbenchSite site, Control control, final String contextId) {
        control.addFocusListener(new FocusListener() {
            IContextActivation contextActivation;

            IContextService getService() {
                if (site == null)
                    return null;
                return (IContextService) site.getService(IContextService.class);
            }

            @Override
            public void focusGained(FocusEvent e) {
                IContextService contextService = getService();
                String ctx = contextId;
                if (contextService != null && ctx != null)
                    contextActivation = contextService.activateContext(ctx);
            }

            @Override
            public void focusLost(FocusEvent e) {
                IContextService contextService = getService();
                if (contextService != null && contextActivation != null)
                    contextService.deactivateContext(contextActivation);
            }
        });
    }

}
