package org.simantics.ui.toolbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.ui.internal.Activator;





public class ToolBarCommandRegistry implements IExtensionChangeHandler {
	private final static String NAMESPACE = Activator.PLUGIN_ID;

	private final static String EP_NAME = "toolbarCommand";
	
	private ExtensionTracker tracker;
	
	private List<ToolbarCommandExtension> extensions = new ArrayList<ToolbarCommandExtension>();
	
	
	private static ToolBarCommandRegistry INSTANCE;
	
	public static synchronized ToolBarCommandRegistry getInstance() {
		if (INSTANCE == null)
			INSTANCE = new ToolBarCommandRegistry();
		return INSTANCE;
	}
	
	public static synchronized void dispose() {
		if (INSTANCE != null) {
			INSTANCE.close();
			INSTANCE = null;
		}	
	}
	
	public ToolBarCommandRegistry() {
		tracker = new ExtensionTracker();
		
		IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE,EP_NAME);
		loadExtensions(ep.getConfigurationElements());
		
		IFilter filter = ExtensionTracker.createExtensionPointFilter(ep);
		tracker.registerHandler(this, filter);
	}
	
	private void close() {
		tracker.close();
		tracker = null;
		extensions.clear();
	}
	
	public synchronized List<ToolbarCommandExtension> getExtensions() {
		return Collections.unmodifiableList(extensions);
	}
	
	private synchronized void loadExtensions(IConfigurationElement[] elements) {
		for (IConfigurationElement el : elements) {
			String commandId = el.getAttribute("commandId");
			
			ToolbarCommandExtension ext = new ToolbarCommandExtension(commandId);
			ext.toolbarId = el.getAttribute("toolbarId");
			ext.image = el.getAttribute("image");
			ext.name = el.getAttribute("name");
			ext.type = el.getAttribute("type");
			ext.value = el.getAttribute("value");
			ext.contributorId = el.getContributor().getName();
			for (IConfigurationElement param : el.getChildren("parameter")) {
				Parameter parameter = new Parameter();
				parameter.name = param.getAttribute("name");
				parameter.value = param.getAttribute("value");
				ext.parameters.add(parameter);
			}
			tracker.registerObject(el.getDeclaringExtension(), ext, IExtensionTracker.REF_STRONG);
			extensions.add(ext);
			
		}
	}
	
	@Override
    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        loadExtensions(extension.getConfigurationElements());
    }
	
	@Override
	public synchronized void removeExtension(IExtension extension, Object[] objects) {
		for (Object o : objects) {
			ToolbarCommandExtension ext = (ToolbarCommandExtension) o;
			tracker.unregisterObject(extension, ext);
			extensions.remove(ext);
		}
	}
	
	public synchronized List<ToolbarCommandExtension> getExtensions(String toolbarId) {
		List<ToolbarCommandExtension> list = new ArrayList<ToolbarCommandExtension>();
		for (ToolbarCommandExtension ext : extensions)
			if (ext.toolbarId.equals(toolbarId))
				list.add(ext);
		return list;
		
	}
	
	public class ToolbarCommandExtension {
		public String commandId;
		public String toolbarId;
		public String name;
		public String type;
		public String value;
		public String image;
		public String contributorId;
		public List<Parameter> parameters = new ArrayList<>();
		public ToolbarCommandExtension(String commandId) {
			super();
			this.commandId = commandId;
		}
		
		@Override
		public String toString() {
			return "ToolbarCommandExtension, commandId= " + commandId + " toolbarId= " + toolbarId + " type= " + type + " value= " + value + " contributor= " + contributorId;
		}
	}
	
	public class Parameter {
		public String name;
		public String value;
	}
	
	
}
